/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import eu.trentorise.opendata.commons.PeriodOfTime;
import eu.trentorise.opendata.commons.TodUtils;
import java.util.Date;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@Beta
abstract class APeriodOfTime {
    public static final String SEP = "@joined@";

    APeriodOfTime() {
    }

    @Value.Default
    public String getStartDate() {
        return "?";
    }

    @Value.Default
    public String getEndDate() {
        return "?";
    }

    @Value.Default
    public String getRawString() {
        return "";
    }

    @Nullable
    private static Date parseDate(@Nullable String s, boolean start) {
        String newDateString = ((String)Preconditions.checkNotNull((Object)s)).trim();
        if (newDateString.equals("?")) {
            if (start) {
                return new Date(Long.MIN_VALUE);
            }
            return new Date(Long.MAX_VALUE);
        }
        if (newDateString.isEmpty()) {
            return null;
        }
        return TodUtils.parseIso8061(newDateString);
    }

    public static boolean isRealDate(Date date, boolean start) {
        long val = start ? Long.MIN_VALUE : Long.MAX_VALUE;
        return date != null && date.getTime() != val;
    }

    @Value.Check
    protected void check() {
        Date start = APeriodOfTime.parseDate(this.getStartDate(), true);
        Date end = APeriodOfTime.parseDate(this.getEndDate(), false);
        if (APeriodOfTime.isRealDate(start, true) && APeriodOfTime.isRealDate(end, false)) {
            Preconditions.checkState((end.getTime() - start.getTime() >= 0L ? 1 : 0) != 0, (String)"Start date %s is greater than end date %s! ", (Object[])new Object[]{start, end});
        }
    }

    public String toFormattedString() {
        return this.getStartDate() + "/" + this.getEndDate();
    }

    public static String joinRawDates(String startDate, String endDate) {
        return startDate + SEP + endDate;
    }

    public static PeriodOfTime of(String rawString) {
        return PeriodOfTime.of("?", "?", rawString);
    }

    public static PeriodOfTime of(String startDate, String endDate) {
        return PeriodOfTime.of(startDate, endDate, APeriodOfTime.joinRawDates(startDate, endDate));
    }
}

