/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import eu.trentorise.opendata.commons.SemVersion;
import java.io.Serializable;
import org.immutables.value.Value;

@Value.Immutable
abstract class ASemVersion
implements Serializable {
    private static final long serialVersionUID = 1L;

    ASemVersion() {
    }

    @Value.Parameter
    @Value.Default
    public int getMajor() {
        return 0;
    }

    @Value.Parameter
    @Value.Default
    public int getMinor() {
        return 0;
    }

    @Value.Parameter
    @Value.Default
    public int getPatch() {
        return 0;
    }

    @Value.Parameter
    @Value.Default
    public String getPreReleaseVersion() {
        return "";
    }

    public static SemVersion of(String string) {
        String p;
        String zString;
        String[] tokens = string.split("\\.");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("Couldn't find three numbers separated by dots in version string " + string);
        }
        int x = Integer.parseInt(tokens[0]);
        int y = Integer.parseInt(tokens[1]);
        int minusIndex = tokens[2].indexOf(45);
        if (minusIndex == -1) {
            zString = tokens[2];
            p = "";
        } else {
            zString = tokens[2].substring(0, minusIndex);
            p = minusIndex == tokens[2].length() - 1 ? "" : tokens[2].substring(minusIndex + 1);
        }
        int z = Integer.parseInt(zString);
        return SemVersion.of(x, y, z, p);
    }

    public String toString() {
        String ret = "" + this.getMajor() + "." + this.getMinor() + "." + this.getPatch();
        if (this.getPreReleaseVersion().length() > 0) {
            return ret + "-" + this.getPreReleaseVersion();
        }
        return ret;
    }
}

