/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.ABuildInfo;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class BuildInfo
extends ABuildInfo {
    private final String version;
    private final String builtBy;
    private final String buildJdk;
    private final String createdBy;
    private final String gitSha;
    private final String scmUrl;
    private final String timestamp;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final BuildInfo INSTANCE = BuildInfo.validate(new BuildInfo());
    private static final long serialVersionUID = 1L;

    private BuildInfo() {
        this.version = this.initShim.getVersion();
        this.builtBy = this.initShim.getBuiltBy();
        this.buildJdk = this.initShim.getBuildJdk();
        this.createdBy = this.initShim.getCreatedBy();
        this.gitSha = this.initShim.getGitSha();
        this.scmUrl = this.initShim.getScmUrl();
        this.timestamp = this.initShim.getTimestamp();
        this.initShim = null;
    }

    private BuildInfo(Builder builder) {
        if (builder.version != null) {
            this.initShim.setVersion(builder.version);
        }
        if (builder.builtBy != null) {
            this.initShim.setBuiltBy(builder.builtBy);
        }
        if (builder.buildJdk != null) {
            this.initShim.setBuildJdk(builder.buildJdk);
        }
        if (builder.createdBy != null) {
            this.initShim.setCreatedBy(builder.createdBy);
        }
        if (builder.gitSha != null) {
            this.initShim.setGitSha(builder.gitSha);
        }
        if (builder.scmUrl != null) {
            this.initShim.setScmUrl(builder.scmUrl);
        }
        if (builder.timestamp != null) {
            this.initShim.setTimestamp(builder.timestamp);
        }
        this.version = this.initShim.getVersion();
        this.builtBy = this.initShim.getBuiltBy();
        this.buildJdk = this.initShim.getBuildJdk();
        this.createdBy = this.initShim.getCreatedBy();
        this.gitSha = this.initShim.getGitSha();
        this.scmUrl = this.initShim.getScmUrl();
        this.timestamp = this.initShim.getTimestamp();
        this.initShim = null;
    }

    private BuildInfo(String version, String builtBy, String buildJdk, String createdBy, String gitSha, String scmUrl, String timestamp) {
        this.version = version;
        this.builtBy = builtBy;
        this.buildJdk = buildJdk;
        this.createdBy = createdBy;
        this.gitSha = gitSha;
        this.scmUrl = scmUrl;
        this.timestamp = timestamp;
        this.initShim = null;
    }

    @Override
    public String getVersion() {
        return this.initShim != null ? this.initShim.getVersion() : this.version;
    }

    @Override
    public String getBuiltBy() {
        return this.initShim != null ? this.initShim.getBuiltBy() : this.builtBy;
    }

    @Override
    public String getBuildJdk() {
        return this.initShim != null ? this.initShim.getBuildJdk() : this.buildJdk;
    }

    @Override
    public String getCreatedBy() {
        return this.initShim != null ? this.initShim.getCreatedBy() : this.createdBy;
    }

    @Override
    public String getGitSha() {
        return this.initShim != null ? this.initShim.getGitSha() : this.gitSha;
    }

    @Override
    public String getScmUrl() {
        return this.initShim != null ? this.initShim.getScmUrl() : this.scmUrl;
    }

    @Override
    public String getTimestamp() {
        return this.initShim != null ? this.initShim.getTimestamp() : this.timestamp;
    }

    public final BuildInfo withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return BuildInfo.validate(new BuildInfo(newValue, this.builtBy, this.buildJdk, this.createdBy, this.gitSha, this.scmUrl, this.timestamp));
    }

    public final BuildInfo withBuiltBy(String value) {
        if (this.builtBy == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return BuildInfo.validate(new BuildInfo(this.version, newValue, this.buildJdk, this.createdBy, this.gitSha, this.scmUrl, this.timestamp));
    }

    public final BuildInfo withBuildJdk(String value) {
        if (this.buildJdk == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return BuildInfo.validate(new BuildInfo(this.version, this.builtBy, newValue, this.createdBy, this.gitSha, this.scmUrl, this.timestamp));
    }

    public final BuildInfo withCreatedBy(String value) {
        if (this.createdBy == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return BuildInfo.validate(new BuildInfo(this.version, this.builtBy, this.buildJdk, newValue, this.gitSha, this.scmUrl, this.timestamp));
    }

    public final BuildInfo withGitSha(String value) {
        if (this.gitSha == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return BuildInfo.validate(new BuildInfo(this.version, this.builtBy, this.buildJdk, this.createdBy, newValue, this.scmUrl, this.timestamp));
    }

    public final BuildInfo withScmUrl(String value) {
        if (this.scmUrl == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return BuildInfo.validate(new BuildInfo(this.version, this.builtBy, this.buildJdk, this.createdBy, this.gitSha, newValue, this.timestamp));
    }

    public final BuildInfo withTimestamp(String value) {
        if (this.timestamp == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return BuildInfo.validate(new BuildInfo(this.version, this.builtBy, this.buildJdk, this.createdBy, this.gitSha, this.scmUrl, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BuildInfo && this.equalTo((BuildInfo)another);
    }

    private boolean equalTo(BuildInfo another) {
        return this.version.equals(another.version) && this.builtBy.equals(another.builtBy) && this.buildJdk.equals(another.buildJdk) && this.createdBy.equals(another.createdBy) && this.gitSha.equals(another.gitSha) && this.scmUrl.equals(another.scmUrl) && this.timestamp.equals(another.timestamp);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.version.hashCode();
        h = h * 17 + this.builtBy.hashCode();
        h = h * 17 + this.buildJdk.hashCode();
        h = h * 17 + this.createdBy.hashCode();
        h = h * 17 + this.gitSha.hashCode();
        h = h * 17 + this.scmUrl.hashCode();
        h = h * 17 + this.timestamp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BuildInfo").add("version", (Object)this.version).add("builtBy", (Object)this.builtBy).add("buildJdk", (Object)this.buildJdk).add("createdBy", (Object)this.createdBy).add("gitSha", (Object)this.gitSha).add("scmUrl", (Object)this.scmUrl).add("timestamp", (Object)this.timestamp).toString();
    }

    public static BuildInfo of() {
        return INSTANCE;
    }

    private static BuildInfo validate(BuildInfo instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static BuildInfo copyOf(BuildInfo instance) {
        if (instance instanceof BuildInfo) {
            return instance;
        }
        return BuildInfo.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return BuildInfo.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String version;
        @Nullable
        private String builtBy;
        @Nullable
        private String buildJdk;
        @Nullable
        private String createdBy;
        @Nullable
        private String gitSha;
        @Nullable
        private String scmUrl;
        @Nullable
        private String timestamp;

        private Builder() {
        }

        public final Builder from(BuildInfo instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setVersion(instance.getVersion());
            this.setBuiltBy(instance.getBuiltBy());
            this.setBuildJdk(instance.getBuildJdk());
            this.setCreatedBy(instance.getCreatedBy());
            this.setGitSha(instance.getGitSha());
            this.setScmUrl(instance.getScmUrl());
            this.setTimestamp(instance.getTimestamp());
            return this;
        }

        public final Builder setVersion(String version) {
            this.version = (String)Preconditions.checkNotNull((Object)version);
            return this;
        }

        public final Builder setBuiltBy(String builtBy) {
            this.builtBy = (String)Preconditions.checkNotNull((Object)builtBy);
            return this;
        }

        public final Builder setBuildJdk(String buildJdk) {
            this.buildJdk = (String)Preconditions.checkNotNull((Object)buildJdk);
            return this;
        }

        public final Builder setCreatedBy(String createdBy) {
            this.createdBy = (String)Preconditions.checkNotNull((Object)createdBy);
            return this;
        }

        public final Builder setGitSha(String gitSha) {
            this.gitSha = (String)Preconditions.checkNotNull((Object)gitSha);
            return this;
        }

        public final Builder setScmUrl(String scmUrl) {
            this.scmUrl = (String)Preconditions.checkNotNull((Object)scmUrl);
            return this;
        }

        public final Builder setTimestamp(String timestamp) {
            this.timestamp = (String)Preconditions.checkNotNull((Object)timestamp);
            return this;
        }

        public BuildInfo build() throws IllegalStateException {
            return BuildInfo.validate(new BuildInfo(this));
        }
    }

    private final class InitShim {
        private String version;
        private byte versionStage;
        private String builtBy;
        private byte builtByStage;
        private String buildJdk;
        private byte buildJdkStage;
        private String createdBy;
        private byte createdByStage;
        private String gitSha;
        private byte gitShaStage;
        private String scmUrl;
        private byte scmUrlStage;
        private String timestamp;
        private byte timestampStage;

        private InitShim() {
        }

        String getVersion() {
            if (this.versionStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionStage == 0) {
                this.versionStage = (byte)-1;
                this.version = (String)Preconditions.checkNotNull((Object)BuildInfo.super.getVersion());
                this.versionStage = 1;
            }
            return this.version;
        }

        String setVersion(String value) {
            this.version = value;
            this.versionStage = 1;
            return value;
        }

        String getBuiltBy() {
            if (this.builtByStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.builtByStage == 0) {
                this.builtByStage = (byte)-1;
                this.builtBy = (String)Preconditions.checkNotNull((Object)BuildInfo.super.getBuiltBy());
                this.builtByStage = 1;
            }
            return this.builtBy;
        }

        String setBuiltBy(String value) {
            this.builtBy = value;
            this.builtByStage = 1;
            return value;
        }

        String getBuildJdk() {
            if (this.buildJdkStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.buildJdkStage == 0) {
                this.buildJdkStage = (byte)-1;
                this.buildJdk = (String)Preconditions.checkNotNull((Object)BuildInfo.super.getBuildJdk());
                this.buildJdkStage = 1;
            }
            return this.buildJdk;
        }

        String setBuildJdk(String value) {
            this.buildJdk = value;
            this.buildJdkStage = 1;
            return value;
        }

        String getCreatedBy() {
            if (this.createdByStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdByStage == 0) {
                this.createdByStage = (byte)-1;
                this.createdBy = (String)Preconditions.checkNotNull((Object)BuildInfo.super.getCreatedBy());
                this.createdByStage = 1;
            }
            return this.createdBy;
        }

        String setCreatedBy(String value) {
            this.createdBy = value;
            this.createdByStage = 1;
            return value;
        }

        String getGitSha() {
            if (this.gitShaStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gitShaStage == 0) {
                this.gitShaStage = (byte)-1;
                this.gitSha = (String)Preconditions.checkNotNull((Object)BuildInfo.super.getGitSha());
                this.gitShaStage = 1;
            }
            return this.gitSha;
        }

        String setGitSha(String value) {
            this.gitSha = value;
            this.gitShaStage = 1;
            return value;
        }

        String getScmUrl() {
            if (this.scmUrlStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scmUrlStage == 0) {
                this.scmUrlStage = (byte)-1;
                this.scmUrl = (String)Preconditions.checkNotNull((Object)BuildInfo.super.getScmUrl());
                this.scmUrlStage = 1;
            }
            return this.scmUrl;
        }

        String setScmUrl(String value) {
            this.scmUrl = value;
            this.scmUrlStage = 1;
            return value;
        }

        String getTimestamp() {
            if (this.timestampStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timestampStage == 0) {
                this.timestampStage = (byte)-1;
                this.timestamp = (String)Preconditions.checkNotNull((Object)BuildInfo.super.getTimestamp());
                this.timestampStage = 1;
            }
            return this.timestamp;
        }

        String setTimestamp(String value) {
            this.timestamp = value;
            this.timestampStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.versionStage == -1) {
                attributes.add("version");
            }
            if (this.builtByStage == -1) {
                attributes.add("builtBy");
            }
            if (this.buildJdkStage == -1) {
                attributes.add("buildJdk");
            }
            if (this.createdByStage == -1) {
                attributes.add("createdBy");
            }
            if (this.gitShaStage == -1) {
                attributes.add("gitSha");
            }
            if (this.scmUrlStage == -1) {
                attributes.add("scmUrl");
            }
            if (this.timestampStage == -1) {
                attributes.add("timestamp");
            }
            return "Cannot build BuildInfo, attribute initializers form cycle" + attributes;
        }
    }
}

