/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.ASemVersion;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class SemVersion
extends ASemVersion {
    private final int major;
    private final int minor;
    private final int patch;
    private final String preReleaseVersion;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final SemVersion INSTANCE = SemVersion.validate(new SemVersion());
    private static final long serialVersionUID = 1L;

    private SemVersion() {
        this.major = this.initShim.getMajor();
        this.minor = this.initShim.getMinor();
        this.patch = this.initShim.getPatch();
        this.preReleaseVersion = this.initShim.getPreReleaseVersion();
        this.initShim = null;
    }

    private SemVersion(int major, int minor, int patch, String preReleaseVersion) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preReleaseVersion = (String)Preconditions.checkNotNull((Object)preReleaseVersion);
        this.initShim = null;
    }

    private SemVersion(SemVersion original, int major, int minor, int patch, String preReleaseVersion) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preReleaseVersion = preReleaseVersion;
        this.initShim = null;
    }

    @Override
    public int getMajor() {
        return this.initShim != null ? this.initShim.getMajor() : this.major;
    }

    @Override
    public int getMinor() {
        return this.initShim != null ? this.initShim.getMinor() : this.minor;
    }

    @Override
    public int getPatch() {
        return this.initShim != null ? this.initShim.getPatch() : this.patch;
    }

    @Override
    public String getPreReleaseVersion() {
        return this.initShim != null ? this.initShim.getPreReleaseVersion() : this.preReleaseVersion;
    }

    public final SemVersion withMajor(int value) {
        if (this.major == value) {
            return this;
        }
        int newValue = value;
        return SemVersion.validate(new SemVersion(this, newValue, this.minor, this.patch, this.preReleaseVersion));
    }

    public final SemVersion withMinor(int value) {
        if (this.minor == value) {
            return this;
        }
        int newValue = value;
        return SemVersion.validate(new SemVersion(this, this.major, newValue, this.patch, this.preReleaseVersion));
    }

    public final SemVersion withPatch(int value) {
        if (this.patch == value) {
            return this;
        }
        int newValue = value;
        return SemVersion.validate(new SemVersion(this, this.major, this.minor, newValue, this.preReleaseVersion));
    }

    public final SemVersion withPreReleaseVersion(String value) {
        if (this.preReleaseVersion == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return SemVersion.validate(new SemVersion(this, this.major, this.minor, this.patch, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SemVersion && this.equalTo((SemVersion)another);
    }

    private boolean equalTo(SemVersion another) {
        return this.major == another.major && this.minor == another.minor && this.patch == another.patch && this.preReleaseVersion.equals(another.preReleaseVersion);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.major;
        h = h * 17 + this.minor;
        h = h * 17 + this.patch;
        h = h * 17 + this.preReleaseVersion.hashCode();
        return h;
    }

    public static SemVersion of() {
        return INSTANCE;
    }

    public static SemVersion of(int major, int minor, int patch, String preReleaseVersion) {
        return SemVersion.validate(new SemVersion(major, minor, patch, preReleaseVersion));
    }

    private static SemVersion validate(SemVersion instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static SemVersion copyOf(SemVersion instance) {
        if (instance instanceof SemVersion) {
            return instance;
        }
        return SemVersion.of(instance.getMajor(), instance.getMinor(), instance.getPatch(), instance.getPreReleaseVersion());
    }

    private Object readResolve() throws ObjectStreamException {
        return SemVersion.validate(this);
    }

    private final class InitShim {
        private int major;
        private byte majorStage;
        private int minor;
        private byte minorStage;
        private int patch;
        private byte patchStage;
        private String preReleaseVersion;
        private byte preReleaseVersionStage;

        private InitShim() {
        }

        int getMajor() {
            if (this.majorStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.majorStage == 0) {
                this.majorStage = (byte)-1;
                this.major = SemVersion.super.getMajor();
                this.majorStage = 1;
            }
            return this.major;
        }

        int setMajor(int value) {
            this.major = value;
            this.majorStage = 1;
            return value;
        }

        int getMinor() {
            if (this.minorStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minorStage == 0) {
                this.minorStage = (byte)-1;
                this.minor = SemVersion.super.getMinor();
                this.minorStage = 1;
            }
            return this.minor;
        }

        int setMinor(int value) {
            this.minor = value;
            this.minorStage = 1;
            return value;
        }

        int getPatch() {
            if (this.patchStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.patchStage == 0) {
                this.patchStage = (byte)-1;
                this.patch = SemVersion.super.getPatch();
                this.patchStage = 1;
            }
            return this.patch;
        }

        int setPatch(int value) {
            this.patch = value;
            this.patchStage = 1;
            return value;
        }

        String getPreReleaseVersion() {
            if (this.preReleaseVersionStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.preReleaseVersionStage == 0) {
                this.preReleaseVersionStage = (byte)-1;
                this.preReleaseVersion = (String)Preconditions.checkNotNull((Object)SemVersion.super.getPreReleaseVersion());
                this.preReleaseVersionStage = 1;
            }
            return this.preReleaseVersion;
        }

        String setPreReleaseVersion(String value) {
            this.preReleaseVersion = value;
            this.preReleaseVersionStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.majorStage == -1) {
                attributes.add("major");
            }
            if (this.minorStage == -1) {
                attributes.add("minor");
            }
            if (this.patchStage == -1) {
                attributes.add("patch");
            }
            if (this.preReleaseVersionStage == -1) {
                attributes.add("preReleaseVersion");
            }
            return "Cannot build SemVersion, attribute initializers form cycle" + attributes;
        }
    }
}

