/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import eu.trentorise.opendata.commons.TodParseException;
import eu.trentorise.opendata.commons.internal.org.apache.commons.lang3.time.DateFormatUtils;
import eu.trentorise.opendata.commons.internal.org.apache.commons.lang3.time.FastDateFormat;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class TodUtils {
    public static final double TOLERANCE = 0.001;
    public static final String UNPARSEABLE = "unparseable:";
    private static final Logger LOG = Logger.getLogger(TodUtils.class.getName());
    public static final String BUILD_PROPERTIES_PATH = "tod.commons.build.properties";
    private static final FastDateFormat ISO_YEAR_FORMAT = FastDateFormat.getInstance("yyyy");
    private static final FastDateFormat ISO_YEAR_MONTH_FORMAT = FastDateFormat.getInstance("yyyy-MM");

    private TodUtils() {
    }

    public static Locale languageTagToLocale(@Nullable String languageTag) {
        if (languageTag == null) {
            LOG.warning("Found null locale, returning Locale.ROOT");
            return Locale.ROOT;
        }
        return Locale.forLanguageTag(languageTag);
    }

    public static String localeToLanguageTag(@Nullable Locale locale) {
        if (locale == null) {
            LOG.warning("Found null locale, returning empty string (which corresponds to Locale.ROOT)");
            return "";
        }
        return locale.getLanguage();
    }

    public static String addSlash(String url) {
        Preconditions.checkNotNull((Object)url, (Object)"invalid url!");
        String trimmedUrl = url.trim();
        if (trimmedUrl.endsWith("/")) {
            return trimmedUrl;
        }
        return trimmedUrl + "/";
    }

    public static String removeTrailingSlash(String url) {
        Preconditions.checkNotNull((Object)url, (Object)"invalid url!");
        String tempUrl = url.trim();
        while (tempUrl.endsWith("/")) {
            tempUrl = tempUrl.substring(0, tempUrl.length() - 1);
        }
        return tempUrl;
    }

    public static String checkNotDirtyUrl(@Nullable String url, @Nullable Object prependedErrorMessage) {
        TodUtils.checkNotEmpty(url, prependedErrorMessage);
        if (url.equalsIgnoreCase("null")) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found URL with string \"" + url + "\" as content!");
        }
        if (url.toLowerCase().endsWith("/null")) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found URL ending with /\"null\": " + url);
        }
        return url;
    }

    public static String checkNotEmpty(String string, @Nullable Object prependedErrorMessage) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null string.", (Object[])new Object[]{prependedErrorMessage});
        if (string.length() == 0) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found empty string.");
        }
        return string;
    }

    public static <T> Collection<T> checkNotEmpty(@Nullable Collection<T> coll, @Nullable Object prependedErrorMessage) {
        Preconditions.checkArgument((coll != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null collection.", (Object[])new Object[]{prependedErrorMessage});
        if (coll.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found empty collection.");
        }
        return coll;
    }

    public static boolean isNotEmpty(@Nullable String string) {
        return string != null && string.length() != 0;
    }

    public static long parseNumericalId(String prefix, String url) {
        String s;
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix can't be null!");
        TodUtils.checkNotEmpty(url, (Object)"Invalid url!");
        if (prefix.length() > 0) {
            int pos = url.indexOf(prefix);
            if (pos != 0) {
                throw new IllegalArgumentException("Invalid URL for prefix " + prefix + ": " + url);
            }
            s = url.substring(prefix.length());
        } else {
            s = url;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid URL for prefix " + prefix + ": " + url, ex);
        }
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        if (template == null) {
            LOG.warning("Found null template while formatting, converting it to \"null\"");
        }
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static Multimap<String, String> parseUrlParams(String url) {
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Ill formed url!", ex);
        }
        LinkedListMultimap queryPairs = LinkedListMultimap.create();
        String[] pairs = u.getQuery().split("&");
        try {
            for (String pair : pairs) {
                int idx = pair.indexOf("=");
                String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : "";
                queryPairs.put((Object)key, (Object)value);
            }
            return queryPairs;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Encoding not supported!", ex);
        }
    }

    public static <K, V> ImmutableMap<K, V> putKey(Map<K, V> map, K key, V newObject) {
        ImmutableMap.Builder mapb = ImmutableMap.builder();
        for (K k : map.keySet()) {
            if (k.equals(key)) continue;
            mapb.put(k, map.get(k));
        }
        mapb.put(key, newObject);
        return mapb.build();
    }

    public static Date parseIso8061(String s) {
        try {
            return DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.parse(s);
        }
        catch (ParseException parseException) {
            try {
                return DateFormatUtils.ISO_DATETIME_FORMAT.parse(s);
            }
            catch (ParseException parseException2) {
                try {
                    return DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.parse(s);
                }
                catch (ParseException parseException3) {
                    try {
                        return DateFormatUtils.ISO_DATE_FORMAT.parse(s);
                    }
                    catch (ParseException parseException4) {
                        try {
                            return ISO_YEAR_MONTH_FORMAT.parse(s);
                        }
                        catch (ParseException parseException5) {
                            try {
                                return ISO_YEAR_FORMAT.parse(s);
                            }
                            catch (ParseException parseException6) {
                                throw new TodParseException("Couldn't parse date as ISO8061. Unparseable date was:" + s);
                            }
                        }
                    }
                }
            }
        }
    }
}

