/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons.validation;

import com.google.common.base.Preconditions;
import eu.trentorise.opendata.commons.validation.Ref;
import java.io.Serializable;
import org.immutables.value.Value;

@Value.Immutable
abstract class ARef
implements Serializable {
    private static final long serialVersionUID = 1L;

    ARef() {
    }

    @Value.Default
    public String getDocumentId() {
        return "";
    }

    @Value.Default
    public long getPhysicalRow() {
        return -1L;
    }

    @Value.Default
    public long getPhysicalColumn() {
        return -1L;
    }

    @Value.Default
    public String getTracePath() {
        return "";
    }

    @Value.Check
    protected void check() {
        Preconditions.checkState((this.getPhysicalRow() >= -1L ? 1 : 0) != 0, (String)"physical row should be grater or equal to -1, found instead %s ", (Object[])new Object[]{this.getPhysicalRow()});
        Preconditions.checkState((this.getPhysicalColumn() >= -1L ? 1 : 0) != 0, (String)"physical column should be grater or equal to -1, found instead %s ", (Object[])new Object[]{this.getPhysicalColumn()});
    }

    public static Ref ofPath(String tracePath) {
        return Ref.builder().setTracePath(tracePath).build();
    }

    public static Ref ofDocumentId(String documentId) {
        return Ref.builder().setDocumentId(documentId).build();
    }

    public String uri() {
        if (this.getDocumentId().isEmpty() && this.getTracePath().isEmpty()) {
            throw new IllegalStateException("Can't create an empty uri!");
        }
        if (this.getDocumentId().isEmpty()) {
            return this.getTracePath();
        }
        if (this.getTracePath().isEmpty() || this.getTracePath().equals("*")) {
            return this.getDocumentId();
        }
        return this.getDocumentId() + "#" + this.getTracePath();
    }
}

