/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons.validation;

import com.google.common.collect.Iterables;
import eu.trentorise.opendata.commons.TodParseException;
import eu.trentorise.opendata.commons.TodUtils;
import javax.annotation.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static String checkNotDirtyUrl(@Nullable String url, @Nullable Object prependedErrorMessage) {
        Preconditions.checkNotEmpty(url, prependedErrorMessage);
        if (url.equalsIgnoreCase("null")) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found URL with string \"" + url + "\" as content!");
        }
        if (url.toLowerCase().endsWith("/null")) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found URL ending with /\"null\": " + url);
        }
        return url;
    }

    public static String checkNotEmpty(String string, @Nullable Object prependedErrorMessage) {
        com.google.common.base.Preconditions.checkArgument((string != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null string.", (Object[])new Object[]{prependedErrorMessage});
        if (string.length() == 0) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found empty string.");
        }
        return string;
    }

    public static String checkNotEmpty(String string, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        String formattedMessage = TodUtils.format(errorMessageTemplate, errorMessageArgs);
        com.google.common.base.Preconditions.checkArgument((string != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null string.", (Object[])new Object[]{formattedMessage});
        if (string.length() == 0) {
            throw new IllegalArgumentException(formattedMessage + " -- Reason: Found empty string.");
        }
        return string;
    }

    public static double checkScore(double score, @Nullable Object prependedErrorMessage) {
        if (score < 0.0) {
            if (score > -0.001) {
                return 0.0;
            }
            throw new IllegalArgumentException("Score must be greater or equal than zero, found instead: " + score);
        }
        if (score >= 1.0) {
            if (score < 1.001) {
                return 1.0;
            }
            throw new IllegalArgumentException("Score must be less than or equal than 1.0, found instead: " + score);
        }
        return score;
    }

    public static <T> Iterable<T> checkNotEmpty(@Nullable Iterable<T> iterable, @Nullable Object prependedErrorMessage) {
        com.google.common.base.Preconditions.checkArgument((iterable != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null iterable.", (Object[])new Object[]{prependedErrorMessage});
        if (Iterables.isEmpty(iterable)) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found empty collection.");
        }
        return iterable;
    }

    public static <T> T[] checkNotEmpty(@Nullable T[] array, @Nullable Object prependedErrorMessage) {
        com.google.common.base.Preconditions.checkArgument((array != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null array.", (Object[])new Object[]{prependedErrorMessage});
        if (array.length == 0) {
            throw new IllegalArgumentException(String.valueOf(prependedErrorMessage) + " -- Reason: Found empty array.");
        }
        return array;
    }

    public static <T> Iterable<T> checkNotEmpty(@Nullable Iterable<T> iterable, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        String formattedMessage = TodUtils.format(errorMessageTemplate, errorMessageArgs);
        com.google.common.base.Preconditions.checkArgument((iterable != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null iterable.", (Object[])new Object[]{formattedMessage});
        if (Iterables.isEmpty(iterable)) {
            throw new IllegalArgumentException(formattedMessage + " -- Reason: Found empty iterable.");
        }
        return iterable;
    }

    public static <T> T[] checkNotEmpty(@Nullable T[] array, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        String formattedMessage = TodUtils.format(errorMessageTemplate, errorMessageArgs);
        com.google.common.base.Preconditions.checkArgument((array != null ? 1 : 0) != 0, (String)"%s -- Reason: Found null iterable.", (Object[])new Object[]{formattedMessage});
        if (array.length == 0) {
            throw new IllegalArgumentException(formattedMessage + " -- Reason: Found empty array.");
        }
        return array;
    }

    private static String checkIso8061(@Nullable String s) {
        String newDate = ((String)com.google.common.base.Preconditions.checkNotNull((Object)s)).trim();
        if (!newDate.isEmpty() && !newDate.equals(Character.valueOf('?'))) {
            try {
                TodUtils.parseIso8061(newDate);
            }
            catch (TodParseException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return newDate;
    }
}

