/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.commons.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import eu.trentorise.opendata.commons.jackson.TodCommonsModule;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
@Beta
public final class Jacksonizer {
    private static final Jacksonizer INSTANCE = new Jacksonizer();
    private ObjectMapper objectMapper = new ObjectMapper();

    private Jacksonizer() {
        this.objectMapper.registerModule((Module)new GuavaModule());
        this.objectMapper.registerModule((Module)new TodCommonsModule());
    }

    private Jacksonizer(ObjectMapper objectMapper) {
        this();
        Preconditions.checkNotNull((Object)objectMapper);
        this.objectMapper = objectMapper;
    }

    public ObjectMapper createJacksonMapper() {
        return this.objectMapper.copy();
    }

    public String toJson(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Couldn't serialize provided object!", ex);
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(jsonString, clazz);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Couldn't deserialize provided SemText json: " + jsonString, ex);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Couldn't deserialize provided SemText json: " + jsonString, ex);
        }
    }

    public static Jacksonizer of() {
        return INSTANCE;
    }

    public static Jacksonizer of(ObjectMapper objectMapper) {
        return new Jacksonizer(objectMapper);
    }
}

