/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.trentorise.opendata.commons.jackson.TodCommonsModule;
import eu.trentorise.opendata.traceprov.exceptions.TraceProvException;
import eu.trentorise.opendata.traceprov.geojson.GeoJson;
import java.io.IOException;

public final class TraceProvModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public TraceProvModule() {
        super("traceprov-jackson", TodCommonsModule.readJacksonVersion(TraceProvModule.class));
        this.addDeserializer(GeoJson.class, (JsonDeserializer)new GeoJsonDeserializer());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public static void registerModulesInto(ObjectMapper om) {
        TodCommonsModule.registerModulesInto((ObjectMapper)om);
        om.registerModule((Module)new TraceProvModule());
    }

    public static class GeoJsonDeserializer
    extends StdDeserializer<GeoJson> {
        public GeoJsonDeserializer() {
            super(GeoJson.class);
        }

        public GeoJsonDeserializer(Class<GeoJson> vc) {
            super(vc);
        }

        public GeoJson deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            ObjectNode root = (ObjectNode)mapper.readTree(jp);
            String type = root.get("type").asText();
            String className = GeoJson.class.getPackage().getName() + "." + type;
            try {
                Class<?> clazz = Class.forName(className);
                return (GeoJson)mapper.convertValue((Object)root, clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new TraceProvException("Cannot resolve geojson class : " + className, ex);
            }
            catch (Exception ex) {
                throw new TraceProvException("Cannot convert json to resolved geojson class: " + className, ex);
            }
        }
    }
}

