/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.traceprov.dcat.ADcatCatalogRecord;
import eu.trentorise.opendata.traceprov.dcat.DcatDataset;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class DcatCatalogRecord
extends ADcatCatalogRecord {
    private final Dict description;
    private final String issued;
    private final String modified;
    @Nullable
    private final DcatDataset primaryTopic;
    private final Dict title;
    private final String uri;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final DcatCatalogRecord INSTANCE = DcatCatalogRecord.validate(new DcatCatalogRecord());
    private static final long serialVersionUID = 1L;

    private DcatCatalogRecord() {
        this.primaryTopic = null;
        this.description = this.initShim.getDescription();
        this.issued = this.initShim.getIssued();
        this.modified = this.initShim.getModified();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatCatalogRecord(Builder builder) {
        this.primaryTopic = builder.primaryTopic;
        if (builder.description != null) {
            this.initShim.setDescription(builder.description);
        }
        if (builder.issued != null) {
            this.initShim.setIssued(builder.issued);
        }
        if (builder.modified != null) {
            this.initShim.setModified(builder.modified);
        }
        if (builder.title != null) {
            this.initShim.setTitle(builder.title);
        }
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        this.description = this.initShim.getDescription();
        this.issued = this.initShim.getIssued();
        this.modified = this.initShim.getModified();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatCatalogRecord(Dict description, String issued, String modified, @Nullable DcatDataset primaryTopic, Dict title, String uri) {
        this.description = description;
        this.issued = issued;
        this.modified = modified;
        this.primaryTopic = primaryTopic;
        this.title = title;
        this.uri = uri;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public Dict getDescription() {
        return this.initShim != null ? this.initShim.getDescription() : this.description;
    }

    @Override
    @JsonProperty
    public String getIssued() {
        return this.initShim != null ? this.initShim.getIssued() : this.issued;
    }

    @Override
    @JsonProperty
    public String getModified() {
        return this.initShim != null ? this.initShim.getModified() : this.modified;
    }

    @Override
    @JsonProperty
    @Nullable
    public DcatDataset getPrimaryTopic() {
        return this.primaryTopic;
    }

    @Override
    @JsonProperty
    public Dict getTitle() {
        return this.initShim != null ? this.initShim.getTitle() : this.title;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    public final DcatCatalogRecord withDescription(Dict value) {
        if (this.description == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatCatalogRecord.validate(new DcatCatalogRecord(newValue, this.issued, this.modified, this.primaryTopic, this.title, this.uri));
    }

    public final DcatCatalogRecord withIssued(String value) {
        if (this.issued == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalogRecord.validate(new DcatCatalogRecord(this.description, newValue, this.modified, this.primaryTopic, this.title, this.uri));
    }

    public final DcatCatalogRecord withModified(String value) {
        if (this.modified == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalogRecord.validate(new DcatCatalogRecord(this.description, this.issued, newValue, this.primaryTopic, this.title, this.uri));
    }

    public final DcatCatalogRecord withPrimaryTopic(@Nullable DcatDataset value) {
        if (this.primaryTopic == value) {
            return this;
        }
        DcatDataset newValue = value;
        return DcatCatalogRecord.validate(new DcatCatalogRecord(this.description, this.issued, this.modified, newValue, this.title, this.uri));
    }

    public final DcatCatalogRecord withTitle(Dict value) {
        if (this.title == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatCatalogRecord.validate(new DcatCatalogRecord(this.description, this.issued, this.modified, this.primaryTopic, newValue, this.uri));
    }

    public final DcatCatalogRecord withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalogRecord.validate(new DcatCatalogRecord(this.description, this.issued, this.modified, this.primaryTopic, this.title, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DcatCatalogRecord && this.equalTo((DcatCatalogRecord)another);
    }

    private boolean equalTo(DcatCatalogRecord another) {
        return this.description.equals((Object)another.description) && this.issued.equals(another.issued) && this.modified.equals(another.modified) && Objects.equal((Object)this.primaryTopic, (Object)another.primaryTopic) && this.title.equals((Object)another.title) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.description.hashCode();
        h = h * 17 + this.issued.hashCode();
        h = h * 17 + this.modified.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.primaryTopic});
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DcatCatalogRecord").add("description", (Object)this.description).add("issued", (Object)this.issued).add("modified", (Object)this.modified).add("primaryTopic", (Object)this.primaryTopic).add("title", (Object)this.title).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator
    static DcatCatalogRecord fromJson(Json json) {
        Builder builder = DcatCatalogRecord.builder();
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.issued != null) {
            builder.setIssued(json.issued);
        }
        if (json.modified != null) {
            builder.setModified(json.modified);
        }
        if (json.primaryTopic != null) {
            builder.setPrimaryTopic(json.primaryTopic);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        return builder.build();
    }

    public static DcatCatalogRecord of() {
        return INSTANCE;
    }

    private static DcatCatalogRecord validate(DcatCatalogRecord instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static DcatCatalogRecord copyOf(DcatCatalogRecord instance) {
        if (instance instanceof DcatCatalogRecord) {
            return instance;
        }
        return DcatCatalogRecord.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return DcatCatalogRecord.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Dict description;
        @Nullable
        private String issued;
        @Nullable
        private String modified;
        @Nullable
        private DcatDataset primaryTopic;
        @Nullable
        private Dict title;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(DcatCatalogRecord instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setDescription(instance.getDescription());
            this.setIssued(instance.getIssued());
            this.setModified(instance.getModified());
            DcatDataset primaryTopicValue = instance.getPrimaryTopic();
            if (primaryTopicValue != null) {
                this.setPrimaryTopic(primaryTopicValue);
            }
            this.setTitle(instance.getTitle());
            this.setUri(instance.getUri());
            return this;
        }

        public final Builder setDescription(Dict description) {
            this.description = (Dict)Preconditions.checkNotNull((Object)description);
            return this;
        }

        public final Builder setIssued(String issued) {
            this.issued = (String)Preconditions.checkNotNull((Object)issued);
            return this;
        }

        public final Builder setModified(String modified) {
            this.modified = (String)Preconditions.checkNotNull((Object)modified);
            return this;
        }

        public final Builder setPrimaryTopic(@Nullable DcatDataset primaryTopic) {
            this.primaryTopic = primaryTopic;
            return this;
        }

        public final Builder setTitle(Dict title) {
            this.title = (Dict)Preconditions.checkNotNull((Object)title);
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public DcatCatalogRecord build() throws IllegalStateException {
            return DcatCatalogRecord.validate(new DcatCatalogRecord(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        Dict description;
        @JsonProperty
        @Nullable
        String issued;
        @JsonProperty
        @Nullable
        String modified;
        @JsonProperty
        @Nullable
        DcatDataset primaryTopic;
        @JsonProperty
        @Nullable
        Dict title;
        @JsonProperty
        @Nullable
        String uri;

        Json() {
        }
    }

    private final class InitShim {
        private Dict description;
        private byte descriptionStage;
        private String issued;
        private byte issuedStage;
        private String modified;
        private byte modifiedStage;
        private Dict title;
        private byte titleStage;
        private String uri;
        private byte uriStage;

        private InitShim() {
        }

        Dict getDescription() {
            if (this.descriptionStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionStage == 0) {
                this.descriptionStage = (byte)-1;
                this.description = (Dict)Preconditions.checkNotNull((Object)DcatCatalogRecord.super.getDescription());
                this.descriptionStage = 1;
            }
            return this.description;
        }

        Dict setDescription(Dict value) {
            this.description = value;
            this.descriptionStage = 1;
            return value;
        }

        String getIssued() {
            if (this.issuedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.issuedStage == 0) {
                this.issuedStage = (byte)-1;
                this.issued = (String)Preconditions.checkNotNull((Object)DcatCatalogRecord.super.getIssued());
                this.issuedStage = 1;
            }
            return this.issued;
        }

        String setIssued(String value) {
            this.issued = value;
            this.issuedStage = 1;
            return value;
        }

        String getModified() {
            if (this.modifiedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedStage == 0) {
                this.modifiedStage = (byte)-1;
                this.modified = (String)Preconditions.checkNotNull((Object)DcatCatalogRecord.super.getModified());
                this.modifiedStage = 1;
            }
            return this.modified;
        }

        String setModified(String value) {
            this.modified = value;
            this.modifiedStage = 1;
            return value;
        }

        Dict getTitle() {
            if (this.titleStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.titleStage == 0) {
                this.titleStage = (byte)-1;
                this.title = (Dict)Preconditions.checkNotNull((Object)DcatCatalogRecord.super.getTitle());
                this.titleStage = 1;
            }
            return this.title;
        }

        Dict setTitle(Dict value) {
            this.title = value;
            this.titleStage = 1;
            return value;
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)DcatCatalogRecord.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.descriptionStage == -1) {
                attributes.add("description");
            }
            if (this.issuedStage == -1) {
                attributes.add("issued");
            }
            if (this.modifiedStage == -1) {
                attributes.add("modified");
            }
            if (this.titleStage == -1) {
                attributes.add("title");
            }
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            return "Cannot build DcatCatalogRecord, attribute initializers form cycle" + attributes;
        }
    }
}

