/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.commons.PeriodOfTime;
import eu.trentorise.opendata.traceprov.dcat.ADcatDataset;
import eu.trentorise.opendata.traceprov.dcat.AFoafAgent;
import eu.trentorise.opendata.traceprov.dcat.DcatDistribution;
import eu.trentorise.opendata.traceprov.dcat.SkosConcept;
import eu.trentorise.opendata.traceprov.dcat.VCard;
import eu.trentorise.opendata.traceprov.geojson.GeoJson;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class DcatDataset
extends ADcatDataset {
    private final String accrualPeriodicity;
    private final VCard contactPoint;
    private final Dict description;
    private final ImmutableList<DcatDistribution> distributions;
    private final String identifier;
    private final String issued;
    private final ImmutableList<String> keywords;
    private final String landingPage;
    private final ImmutableList<Locale> languages;
    private final String modified;
    private final AFoafAgent publisher;
    private final GeoJson spatial;
    private final PeriodOfTime temporal;
    private final ImmutableList<SkosConcept> themes;
    private final Dict title;
    private final String uri;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final DcatDataset INSTANCE = DcatDataset.validate(new DcatDataset());
    private static final long serialVersionUID = 1L;

    private DcatDataset() {
        this.distributions = ImmutableList.of();
        this.keywords = ImmutableList.of();
        this.languages = ImmutableList.of();
        this.themes = ImmutableList.of();
        this.accrualPeriodicity = this.initShim.getAccrualPeriodicity();
        this.contactPoint = this.initShim.getContactPoint();
        this.description = this.initShim.getDescription();
        this.identifier = this.initShim.getIdentifier();
        this.issued = this.initShim.getIssued();
        this.landingPage = this.initShim.getLandingPage();
        this.modified = this.initShim.getModified();
        this.publisher = this.initShim.getPublisher();
        this.spatial = this.initShim.getSpatial();
        this.temporal = this.initShim.getTemporal();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatDataset(Builder builder) {
        this.distributions = builder.distributionsBuilder.build();
        this.keywords = builder.keywordsBuilder.build();
        this.languages = builder.languagesBuilder.build();
        this.themes = builder.themesBuilder.build();
        if (builder.accrualPeriodicity != null) {
            this.initShim.setAccrualPeriodicity(builder.accrualPeriodicity);
        }
        if (builder.contactPoint != null) {
            this.initShim.setContactPoint(builder.contactPoint);
        }
        if (builder.description != null) {
            this.initShim.setDescription(builder.description);
        }
        if (builder.identifier != null) {
            this.initShim.setIdentifier(builder.identifier);
        }
        if (builder.issued != null) {
            this.initShim.setIssued(builder.issued);
        }
        if (builder.landingPage != null) {
            this.initShim.setLandingPage(builder.landingPage);
        }
        if (builder.modified != null) {
            this.initShim.setModified(builder.modified);
        }
        if (builder.publisher != null) {
            this.initShim.setPublisher(builder.publisher);
        }
        if (builder.spatial != null) {
            this.initShim.setSpatial(builder.spatial);
        }
        if (builder.temporal != null) {
            this.initShim.setTemporal(builder.temporal);
        }
        if (builder.title != null) {
            this.initShim.setTitle(builder.title);
        }
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        this.accrualPeriodicity = this.initShim.getAccrualPeriodicity();
        this.contactPoint = this.initShim.getContactPoint();
        this.description = this.initShim.getDescription();
        this.identifier = this.initShim.getIdentifier();
        this.issued = this.initShim.getIssued();
        this.landingPage = this.initShim.getLandingPage();
        this.modified = this.initShim.getModified();
        this.publisher = this.initShim.getPublisher();
        this.spatial = this.initShim.getSpatial();
        this.temporal = this.initShim.getTemporal();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatDataset(String accrualPeriodicity, VCard contactPoint, Dict description, ImmutableList<DcatDistribution> distributions, String identifier, String issued, ImmutableList<String> keywords, String landingPage, ImmutableList<Locale> languages, String modified, AFoafAgent publisher, GeoJson spatial, PeriodOfTime temporal, ImmutableList<SkosConcept> themes, Dict title, String uri) {
        this.accrualPeriodicity = accrualPeriodicity;
        this.contactPoint = contactPoint;
        this.description = description;
        this.distributions = distributions;
        this.identifier = identifier;
        this.issued = issued;
        this.keywords = keywords;
        this.landingPage = landingPage;
        this.languages = languages;
        this.modified = modified;
        this.publisher = publisher;
        this.spatial = spatial;
        this.temporal = temporal;
        this.themes = themes;
        this.title = title;
        this.uri = uri;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getAccrualPeriodicity() {
        return this.initShim != null ? this.initShim.getAccrualPeriodicity() : this.accrualPeriodicity;
    }

    @Override
    @JsonProperty
    public VCard getContactPoint() {
        return this.initShim != null ? this.initShim.getContactPoint() : this.contactPoint;
    }

    @Override
    @JsonProperty
    public Dict getDescription() {
        return this.initShim != null ? this.initShim.getDescription() : this.description;
    }

    @JsonProperty
    public ImmutableList<DcatDistribution> getDistributions() {
        return this.distributions;
    }

    @Override
    @JsonProperty
    public String getIdentifier() {
        return this.initShim != null ? this.initShim.getIdentifier() : this.identifier;
    }

    @Override
    @JsonProperty
    public String getIssued() {
        return this.initShim != null ? this.initShim.getIssued() : this.issued;
    }

    @JsonProperty
    public ImmutableList<String> getKeywords() {
        return this.keywords;
    }

    @Override
    @JsonProperty
    public String getLandingPage() {
        return this.initShim != null ? this.initShim.getLandingPage() : this.landingPage;
    }

    @JsonProperty
    public ImmutableList<Locale> getLanguages() {
        return this.languages;
    }

    @Override
    @JsonProperty
    public String getModified() {
        return this.initShim != null ? this.initShim.getModified() : this.modified;
    }

    @Override
    @JsonProperty
    public AFoafAgent getPublisher() {
        return this.initShim != null ? this.initShim.getPublisher() : this.publisher;
    }

    @Override
    @JsonProperty
    public GeoJson getSpatial() {
        return this.initShim != null ? this.initShim.getSpatial() : this.spatial;
    }

    @Override
    @JsonProperty
    public PeriodOfTime getTemporal() {
        return this.initShim != null ? this.initShim.getTemporal() : this.temporal;
    }

    @JsonProperty
    public ImmutableList<SkosConcept> getThemes() {
        return this.themes;
    }

    @Override
    @JsonProperty
    public Dict getTitle() {
        return this.initShim != null ? this.initShim.getTitle() : this.title;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    public final DcatDataset withAccrualPeriodicity(String value) {
        if (this.accrualPeriodicity == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(newValue, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withContactPoint(VCard value) {
        if (this.contactPoint == value) {
            return this;
        }
        VCard newValue = (VCard)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, newValue, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withDescription(Dict value) {
        if (this.description == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, newValue, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withDistributions(DcatDistribution ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, (ImmutableList<DcatDistribution>)newValue, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withDistributions(Iterable<? extends DcatDistribution> elements) {
        if (this.distributions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, (ImmutableList<DcatDistribution>)newValue, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withIdentifier(String value) {
        if (this.identifier == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, newValue, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withIssued(String value) {
        if (this.issued == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, newValue, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withKeywords(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, (ImmutableList<String>)newValue, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withKeywords(Iterable<String> elements) {
        if (this.keywords == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, (ImmutableList<String>)newValue, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withLandingPage(String value) {
        if (this.landingPage == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, newValue, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withLanguages(Locale ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, (ImmutableList<Locale>)newValue, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withLanguages(Iterable<? extends Locale> elements) {
        if (this.languages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, (ImmutableList<Locale>)newValue, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withModified(String value) {
        if (this.modified == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, newValue, this.publisher, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withPublisher(AFoafAgent value) {
        if (this.publisher == value) {
            return this;
        }
        AFoafAgent newValue = (AFoafAgent)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, newValue, this.spatial, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withSpatial(GeoJson value) {
        if (this.spatial == value) {
            return this;
        }
        GeoJson newValue = (GeoJson)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, newValue, this.temporal, this.themes, this.title, this.uri));
    }

    public final DcatDataset withTemporal(PeriodOfTime value) {
        if (this.temporal == value) {
            return this;
        }
        PeriodOfTime newValue = (PeriodOfTime)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, newValue, this.themes, this.title, this.uri));
    }

    public final DcatDataset withThemes(SkosConcept ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, (ImmutableList<SkosConcept>)newValue, this.title, this.uri));
    }

    public final DcatDataset withThemes(Iterable<? extends SkosConcept> elements) {
        if (this.themes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, (ImmutableList<SkosConcept>)newValue, this.title, this.uri));
    }

    public final DcatDataset withTitle(Dict value) {
        if (this.title == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, newValue, this.uri));
    }

    public final DcatDataset withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDataset.validate(new DcatDataset(this.accrualPeriodicity, this.contactPoint, this.description, this.distributions, this.identifier, this.issued, this.keywords, this.landingPage, this.languages, this.modified, this.publisher, this.spatial, this.temporal, this.themes, this.title, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DcatDataset && this.equalTo((DcatDataset)another);
    }

    private boolean equalTo(DcatDataset another) {
        return this.accrualPeriodicity.equals(another.accrualPeriodicity) && this.contactPoint.equals(another.contactPoint) && this.description.equals((Object)another.description) && this.distributions.equals(another.distributions) && this.identifier.equals(another.identifier) && this.issued.equals(another.issued) && this.keywords.equals(another.keywords) && this.landingPage.equals(another.landingPage) && this.languages.equals(another.languages) && this.modified.equals(another.modified) && this.publisher.equals(another.publisher) && this.spatial.equals(another.spatial) && this.temporal.equals((Object)another.temporal) && this.themes.equals(another.themes) && this.title.equals((Object)another.title) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.accrualPeriodicity.hashCode();
        h = h * 17 + this.contactPoint.hashCode();
        h = h * 17 + this.description.hashCode();
        h = h * 17 + this.distributions.hashCode();
        h = h * 17 + this.identifier.hashCode();
        h = h * 17 + this.issued.hashCode();
        h = h * 17 + this.keywords.hashCode();
        h = h * 17 + this.landingPage.hashCode();
        h = h * 17 + this.languages.hashCode();
        h = h * 17 + this.modified.hashCode();
        h = h * 17 + this.publisher.hashCode();
        h = h * 17 + this.spatial.hashCode();
        h = h * 17 + this.temporal.hashCode();
        h = h * 17 + this.themes.hashCode();
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DcatDataset").add("accrualPeriodicity", (Object)this.accrualPeriodicity).add("contactPoint", (Object)this.contactPoint).add("description", (Object)this.description).add("distributions", this.distributions).add("identifier", (Object)this.identifier).add("issued", (Object)this.issued).add("keywords", this.keywords).add("landingPage", (Object)this.landingPage).add("languages", this.languages).add("modified", (Object)this.modified).add("publisher", (Object)this.publisher).add("spatial", (Object)this.spatial).add("temporal", (Object)this.temporal).add("themes", this.themes).add("title", (Object)this.title).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator
    static DcatDataset fromJson(Json json) {
        Builder builder = DcatDataset.builder();
        if (json.accrualPeriodicity != null) {
            builder.setAccrualPeriodicity(json.accrualPeriodicity);
        }
        if (json.contactPoint != null) {
            builder.setContactPoint(json.contactPoint);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.distributions != null) {
            builder.addAllDistributions(json.distributions);
        }
        if (json.identifier != null) {
            builder.setIdentifier(json.identifier);
        }
        if (json.issued != null) {
            builder.setIssued(json.issued);
        }
        if (json.keywords != null) {
            builder.addAllKeywords(json.keywords);
        }
        if (json.landingPage != null) {
            builder.setLandingPage(json.landingPage);
        }
        if (json.languages != null) {
            builder.addAllLanguages(json.languages);
        }
        if (json.modified != null) {
            builder.setModified(json.modified);
        }
        if (json.publisher != null) {
            builder.setPublisher(json.publisher);
        }
        if (json.spatial != null) {
            builder.setSpatial(json.spatial);
        }
        if (json.temporal != null) {
            builder.setTemporal(json.temporal);
        }
        if (json.themes != null) {
            builder.addAllThemes(json.themes);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        return builder.build();
    }

    public static DcatDataset of() {
        return INSTANCE;
    }

    private static DcatDataset validate(DcatDataset instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static DcatDataset copyOf(DcatDataset instance) {
        if (instance instanceof DcatDataset) {
            return instance;
        }
        return DcatDataset.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return DcatDataset.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String accrualPeriodicity;
        @Nullable
        private VCard contactPoint;
        @Nullable
        private Dict description;
        private ImmutableList.Builder<DcatDistribution> distributionsBuilder = ImmutableList.builder();
        @Nullable
        private String identifier;
        @Nullable
        private String issued;
        private ImmutableList.Builder<String> keywordsBuilder = ImmutableList.builder();
        @Nullable
        private String landingPage;
        private ImmutableList.Builder<Locale> languagesBuilder = ImmutableList.builder();
        @Nullable
        private String modified;
        @Nullable
        private AFoafAgent publisher;
        @Nullable
        private GeoJson spatial;
        @Nullable
        private PeriodOfTime temporal;
        private ImmutableList.Builder<SkosConcept> themesBuilder = ImmutableList.builder();
        @Nullable
        private Dict title;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(DcatDataset instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setAccrualPeriodicity(instance.getAccrualPeriodicity());
            this.setContactPoint(instance.getContactPoint());
            this.setDescription(instance.getDescription());
            this.addAllDistributions((Iterable<? extends DcatDistribution>)instance.getDistributions());
            this.setIdentifier(instance.getIdentifier());
            this.setIssued(instance.getIssued());
            this.addAllKeywords((Iterable<String>)instance.getKeywords());
            this.setLandingPage(instance.getLandingPage());
            this.addAllLanguages((Iterable<? extends Locale>)instance.getLanguages());
            this.setModified(instance.getModified());
            this.setPublisher(instance.getPublisher());
            this.setSpatial(instance.getSpatial());
            this.setTemporal(instance.getTemporal());
            this.addAllThemes((Iterable<? extends SkosConcept>)instance.getThemes());
            this.setTitle(instance.getTitle());
            this.setUri(instance.getUri());
            return this;
        }

        public final Builder setAccrualPeriodicity(String accrualPeriodicity) {
            this.accrualPeriodicity = (String)Preconditions.checkNotNull((Object)accrualPeriodicity);
            return this;
        }

        public final Builder setContactPoint(VCard contactPoint) {
            this.contactPoint = (VCard)Preconditions.checkNotNull((Object)contactPoint);
            return this;
        }

        public final Builder setDescription(Dict description) {
            this.description = (Dict)Preconditions.checkNotNull((Object)description);
            return this;
        }

        public final Builder addDistributions(DcatDistribution element) {
            this.distributionsBuilder.add((Object)element);
            return this;
        }

        public final Builder addDistributions(DcatDistribution ... elements) {
            this.distributionsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setDistributions(Iterable<? extends DcatDistribution> elements) {
            this.distributionsBuilder = ImmutableList.builder();
            return this.addAllDistributions(elements);
        }

        public final Builder addAllDistributions(Iterable<? extends DcatDistribution> elements) {
            this.distributionsBuilder.addAll(elements);
            return this;
        }

        public final Builder setIdentifier(String identifier) {
            this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
            return this;
        }

        public final Builder setIssued(String issued) {
            this.issued = (String)Preconditions.checkNotNull((Object)issued);
            return this;
        }

        public final Builder addKeywords(String element) {
            this.keywordsBuilder.add((Object)element);
            return this;
        }

        public final Builder addKeywords(String ... elements) {
            this.keywordsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setKeywords(Iterable<String> elements) {
            this.keywordsBuilder = ImmutableList.builder();
            return this.addAllKeywords(elements);
        }

        public final Builder addAllKeywords(Iterable<String> elements) {
            this.keywordsBuilder.addAll(elements);
            return this;
        }

        public final Builder setLandingPage(String landingPage) {
            this.landingPage = (String)Preconditions.checkNotNull((Object)landingPage);
            return this;
        }

        public final Builder addLanguages(Locale element) {
            this.languagesBuilder.add((Object)element);
            return this;
        }

        public final Builder addLanguages(Locale ... elements) {
            this.languagesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setLanguages(Iterable<? extends Locale> elements) {
            this.languagesBuilder = ImmutableList.builder();
            return this.addAllLanguages(elements);
        }

        public final Builder addAllLanguages(Iterable<? extends Locale> elements) {
            this.languagesBuilder.addAll(elements);
            return this;
        }

        public final Builder setModified(String modified) {
            this.modified = (String)Preconditions.checkNotNull((Object)modified);
            return this;
        }

        public final Builder setPublisher(AFoafAgent publisher) {
            this.publisher = (AFoafAgent)Preconditions.checkNotNull((Object)publisher);
            return this;
        }

        public final Builder setSpatial(GeoJson spatial) {
            this.spatial = (GeoJson)Preconditions.checkNotNull((Object)spatial);
            return this;
        }

        public final Builder setTemporal(PeriodOfTime temporal) {
            this.temporal = (PeriodOfTime)Preconditions.checkNotNull((Object)temporal);
            return this;
        }

        public final Builder addThemes(SkosConcept element) {
            this.themesBuilder.add((Object)element);
            return this;
        }

        public final Builder addThemes(SkosConcept ... elements) {
            this.themesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setThemes(Iterable<? extends SkosConcept> elements) {
            this.themesBuilder = ImmutableList.builder();
            return this.addAllThemes(elements);
        }

        public final Builder addAllThemes(Iterable<? extends SkosConcept> elements) {
            this.themesBuilder.addAll(elements);
            return this;
        }

        public final Builder setTitle(Dict title) {
            this.title = (Dict)Preconditions.checkNotNull((Object)title);
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public DcatDataset build() throws IllegalStateException {
            return DcatDataset.validate(new DcatDataset(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String accrualPeriodicity;
        @JsonProperty
        @Nullable
        VCard contactPoint;
        @JsonProperty
        @Nullable
        Dict description;
        @JsonProperty
        @Nullable
        List<DcatDistribution> distributions;
        @JsonProperty
        @Nullable
        String identifier;
        @JsonProperty
        @Nullable
        String issued;
        @JsonProperty
        @Nullable
        List<String> keywords;
        @JsonProperty
        @Nullable
        String landingPage;
        @JsonProperty
        @Nullable
        List<Locale> languages;
        @JsonProperty
        @Nullable
        String modified;
        @JsonProperty
        @Nullable
        AFoafAgent publisher;
        @JsonProperty
        @Nullable
        GeoJson spatial;
        @JsonProperty
        @Nullable
        PeriodOfTime temporal;
        @JsonProperty
        @Nullable
        List<SkosConcept> themes;
        @JsonProperty
        @Nullable
        Dict title;
        @JsonProperty
        @Nullable
        String uri;

        Json() {
        }
    }

    private final class InitShim {
        private String accrualPeriodicity;
        private byte accrualPeriodicityStage;
        private VCard contactPoint;
        private byte contactPointStage;
        private Dict description;
        private byte descriptionStage;
        private String identifier;
        private byte identifierStage;
        private String issued;
        private byte issuedStage;
        private String landingPage;
        private byte landingPageStage;
        private String modified;
        private byte modifiedStage;
        private AFoafAgent publisher;
        private byte publisherStage;
        private GeoJson spatial;
        private byte spatialStage;
        private PeriodOfTime temporal;
        private byte temporalStage;
        private Dict title;
        private byte titleStage;
        private String uri;
        private byte uriStage;

        private InitShim() {
        }

        String getAccrualPeriodicity() {
            if (this.accrualPeriodicityStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.accrualPeriodicityStage == 0) {
                this.accrualPeriodicityStage = (byte)-1;
                this.accrualPeriodicity = (String)Preconditions.checkNotNull((Object)DcatDataset.super.getAccrualPeriodicity());
                this.accrualPeriodicityStage = 1;
            }
            return this.accrualPeriodicity;
        }

        String setAccrualPeriodicity(String value) {
            this.accrualPeriodicity = value;
            this.accrualPeriodicityStage = 1;
            return value;
        }

        VCard getContactPoint() {
            if (this.contactPointStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contactPointStage == 0) {
                this.contactPointStage = (byte)-1;
                this.contactPoint = (VCard)Preconditions.checkNotNull((Object)DcatDataset.super.getContactPoint());
                this.contactPointStage = 1;
            }
            return this.contactPoint;
        }

        VCard setContactPoint(VCard value) {
            this.contactPoint = value;
            this.contactPointStage = 1;
            return value;
        }

        Dict getDescription() {
            if (this.descriptionStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionStage == 0) {
                this.descriptionStage = (byte)-1;
                this.description = (Dict)Preconditions.checkNotNull((Object)DcatDataset.super.getDescription());
                this.descriptionStage = 1;
            }
            return this.description;
        }

        Dict setDescription(Dict value) {
            this.description = value;
            this.descriptionStage = 1;
            return value;
        }

        String getIdentifier() {
            if (this.identifierStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierStage == 0) {
                this.identifierStage = (byte)-1;
                this.identifier = (String)Preconditions.checkNotNull((Object)DcatDataset.super.getIdentifier());
                this.identifierStage = 1;
            }
            return this.identifier;
        }

        String setIdentifier(String value) {
            this.identifier = value;
            this.identifierStage = 1;
            return value;
        }

        String getIssued() {
            if (this.issuedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.issuedStage == 0) {
                this.issuedStage = (byte)-1;
                this.issued = (String)Preconditions.checkNotNull((Object)DcatDataset.super.getIssued());
                this.issuedStage = 1;
            }
            return this.issued;
        }

        String setIssued(String value) {
            this.issued = value;
            this.issuedStage = 1;
            return value;
        }

        String getLandingPage() {
            if (this.landingPageStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.landingPageStage == 0) {
                this.landingPageStage = (byte)-1;
                this.landingPage = (String)Preconditions.checkNotNull((Object)DcatDataset.super.getLandingPage());
                this.landingPageStage = 1;
            }
            return this.landingPage;
        }

        String setLandingPage(String value) {
            this.landingPage = value;
            this.landingPageStage = 1;
            return value;
        }

        String getModified() {
            if (this.modifiedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedStage == 0) {
                this.modifiedStage = (byte)-1;
                this.modified = (String)Preconditions.checkNotNull((Object)DcatDataset.super.getModified());
                this.modifiedStage = 1;
            }
            return this.modified;
        }

        String setModified(String value) {
            this.modified = value;
            this.modifiedStage = 1;
            return value;
        }

        AFoafAgent getPublisher() {
            if (this.publisherStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.publisherStage == 0) {
                this.publisherStage = (byte)-1;
                this.publisher = (AFoafAgent)Preconditions.checkNotNull((Object)DcatDataset.super.getPublisher());
                this.publisherStage = 1;
            }
            return this.publisher;
        }

        AFoafAgent setPublisher(AFoafAgent value) {
            this.publisher = value;
            this.publisherStage = 1;
            return value;
        }

        GeoJson getSpatial() {
            if (this.spatialStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spatialStage == 0) {
                this.spatialStage = (byte)-1;
                this.spatial = (GeoJson)Preconditions.checkNotNull((Object)DcatDataset.super.getSpatial());
                this.spatialStage = 1;
            }
            return this.spatial;
        }

        GeoJson setSpatial(GeoJson value) {
            this.spatial = value;
            this.spatialStage = 1;
            return value;
        }

        PeriodOfTime getTemporal() {
            if (this.temporalStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.temporalStage == 0) {
                this.temporalStage = (byte)-1;
                this.temporal = (PeriodOfTime)Preconditions.checkNotNull((Object)DcatDataset.super.getTemporal());
                this.temporalStage = 1;
            }
            return this.temporal;
        }

        PeriodOfTime setTemporal(PeriodOfTime value) {
            this.temporal = value;
            this.temporalStage = 1;
            return value;
        }

        Dict getTitle() {
            if (this.titleStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.titleStage == 0) {
                this.titleStage = (byte)-1;
                this.title = (Dict)Preconditions.checkNotNull((Object)DcatDataset.super.getTitle());
                this.titleStage = 1;
            }
            return this.title;
        }

        Dict setTitle(Dict value) {
            this.title = value;
            this.titleStage = 1;
            return value;
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)DcatDataset.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.accrualPeriodicityStage == -1) {
                attributes.add("accrualPeriodicity");
            }
            if (this.contactPointStage == -1) {
                attributes.add("contactPoint");
            }
            if (this.descriptionStage == -1) {
                attributes.add("description");
            }
            if (this.identifierStage == -1) {
                attributes.add("identifier");
            }
            if (this.issuedStage == -1) {
                attributes.add("issued");
            }
            if (this.landingPageStage == -1) {
                attributes.add("landingPage");
            }
            if (this.modifiedStage == -1) {
                attributes.add("modified");
            }
            if (this.publisherStage == -1) {
                attributes.add("publisher");
            }
            if (this.spatialStage == -1) {
                attributes.add("spatial");
            }
            if (this.temporalStage == -1) {
                attributes.add("temporal");
            }
            if (this.titleStage == -1) {
                attributes.add("title");
            }
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            return "Cannot build DcatDataset, attribute initializers form cycle" + attributes;
        }
    }
}

