/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.traceprov.dcat.ADcatDistribution;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class DcatDistribution
extends ADcatDistribution {
    private final String accessURL;
    private final int byteSize;
    private final String datasetUri;
    private final Dict description;
    private final String downloadURL;
    private final String format;
    private final String issued;
    private final Locale language;
    private final String license;
    private final String mediaType;
    private final String modified;
    private final String rights;
    private final Dict title;
    private final String uri;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final DcatDistribution INSTANCE = DcatDistribution.validate(new DcatDistribution());
    private static final long serialVersionUID = 1L;

    private DcatDistribution() {
        this.accessURL = this.initShim.getAccessURL();
        this.byteSize = this.initShim.getByteSize();
        this.datasetUri = this.initShim.getDatasetUri();
        this.description = this.initShim.getDescription();
        this.downloadURL = this.initShim.getDownloadURL();
        this.format = this.initShim.getFormat();
        this.issued = this.initShim.getIssued();
        this.language = this.initShim.getLanguage();
        this.license = this.initShim.getLicense();
        this.mediaType = this.initShim.getMediaType();
        this.modified = this.initShim.getModified();
        this.rights = this.initShim.getRights();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatDistribution(Builder builder) {
        if (builder.accessURL != null) {
            this.initShim.setAccessURL(builder.accessURL);
        }
        if (builder.byteSizeIsSet()) {
            this.initShim.setByteSize(builder.byteSize);
        }
        if (builder.datasetUri != null) {
            this.initShim.setDatasetUri(builder.datasetUri);
        }
        if (builder.description != null) {
            this.initShim.setDescription(builder.description);
        }
        if (builder.downloadURL != null) {
            this.initShim.setDownloadURL(builder.downloadURL);
        }
        if (builder.format != null) {
            this.initShim.setFormat(builder.format);
        }
        if (builder.issued != null) {
            this.initShim.setIssued(builder.issued);
        }
        if (builder.language != null) {
            this.initShim.setLanguage(builder.language);
        }
        if (builder.license != null) {
            this.initShim.setLicense(builder.license);
        }
        if (builder.mediaType != null) {
            this.initShim.setMediaType(builder.mediaType);
        }
        if (builder.modified != null) {
            this.initShim.setModified(builder.modified);
        }
        if (builder.rights != null) {
            this.initShim.setRights(builder.rights);
        }
        if (builder.title != null) {
            this.initShim.setTitle(builder.title);
        }
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        this.accessURL = this.initShim.getAccessURL();
        this.byteSize = this.initShim.getByteSize();
        this.datasetUri = this.initShim.getDatasetUri();
        this.description = this.initShim.getDescription();
        this.downloadURL = this.initShim.getDownloadURL();
        this.format = this.initShim.getFormat();
        this.issued = this.initShim.getIssued();
        this.language = this.initShim.getLanguage();
        this.license = this.initShim.getLicense();
        this.mediaType = this.initShim.getMediaType();
        this.modified = this.initShim.getModified();
        this.rights = this.initShim.getRights();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatDistribution(String accessURL, int byteSize, String datasetUri, Dict description, String downloadURL, String format, String issued, Locale language, String license, String mediaType, String modified, String rights, Dict title, String uri) {
        this.accessURL = accessURL;
        this.byteSize = byteSize;
        this.datasetUri = datasetUri;
        this.description = description;
        this.downloadURL = downloadURL;
        this.format = format;
        this.issued = issued;
        this.language = language;
        this.license = license;
        this.mediaType = mediaType;
        this.modified = modified;
        this.rights = rights;
        this.title = title;
        this.uri = uri;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getAccessURL() {
        return this.initShim != null ? this.initShim.getAccessURL() : this.accessURL;
    }

    @Override
    @JsonProperty
    public int getByteSize() {
        return this.initShim != null ? this.initShim.getByteSize() : this.byteSize;
    }

    @Override
    @JsonProperty
    public String getDatasetUri() {
        return this.initShim != null ? this.initShim.getDatasetUri() : this.datasetUri;
    }

    @Override
    @JsonProperty
    public Dict getDescription() {
        return this.initShim != null ? this.initShim.getDescription() : this.description;
    }

    @Override
    @JsonProperty
    public String getDownloadURL() {
        return this.initShim != null ? this.initShim.getDownloadURL() : this.downloadURL;
    }

    @Override
    @JsonProperty
    public String getFormat() {
        return this.initShim != null ? this.initShim.getFormat() : this.format;
    }

    @Override
    @JsonProperty
    public String getIssued() {
        return this.initShim != null ? this.initShim.getIssued() : this.issued;
    }

    @Override
    @JsonProperty
    public Locale getLanguage() {
        return this.initShim != null ? this.initShim.getLanguage() : this.language;
    }

    @Override
    @JsonProperty
    public String getLicense() {
        return this.initShim != null ? this.initShim.getLicense() : this.license;
    }

    @Override
    @JsonProperty
    public String getMediaType() {
        return this.initShim != null ? this.initShim.getMediaType() : this.mediaType;
    }

    @Override
    @JsonProperty
    public String getModified() {
        return this.initShim != null ? this.initShim.getModified() : this.modified;
    }

    @Override
    @JsonProperty
    public String getRights() {
        return this.initShim != null ? this.initShim.getRights() : this.rights;
    }

    @Override
    @JsonProperty
    public Dict getTitle() {
        return this.initShim != null ? this.initShim.getTitle() : this.title;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    public final DcatDistribution withAccessURL(String value) {
        if (this.accessURL == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(newValue, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withByteSize(int value) {
        if (this.byteSize == value) {
            return this;
        }
        int newValue = value;
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, newValue, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withDatasetUri(String value) {
        if (this.datasetUri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, newValue, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withDescription(Dict value) {
        if (this.description == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, newValue, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withDownloadURL(String value) {
        if (this.downloadURL == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, newValue, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withFormat(String value) {
        if (this.format == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, newValue, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withIssued(String value) {
        if (this.issued == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, newValue, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withLanguage(Locale value) {
        if (this.language == value) {
            return this;
        }
        Locale newValue = (Locale)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, newValue, this.license, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withLicense(String value) {
        if (this.license == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, newValue, this.mediaType, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withMediaType(String value) {
        if (this.mediaType == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, newValue, this.modified, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withModified(String value) {
        if (this.modified == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, newValue, this.rights, this.title, this.uri));
    }

    public final DcatDistribution withRights(String value) {
        if (this.rights == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, newValue, this.title, this.uri));
    }

    public final DcatDistribution withTitle(Dict value) {
        if (this.title == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, newValue, this.uri));
    }

    public final DcatDistribution withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatDistribution.validate(new DcatDistribution(this.accessURL, this.byteSize, this.datasetUri, this.description, this.downloadURL, this.format, this.issued, this.language, this.license, this.mediaType, this.modified, this.rights, this.title, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DcatDistribution && this.equalTo((DcatDistribution)another);
    }

    private boolean equalTo(DcatDistribution another) {
        return this.accessURL.equals(another.accessURL) && this.byteSize == another.byteSize && this.datasetUri.equals(another.datasetUri) && this.description.equals((Object)another.description) && this.downloadURL.equals(another.downloadURL) && this.format.equals(another.format) && this.issued.equals(another.issued) && this.language.equals(another.language) && this.license.equals(another.license) && this.mediaType.equals(another.mediaType) && this.modified.equals(another.modified) && this.rights.equals(another.rights) && this.title.equals((Object)another.title) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.accessURL.hashCode();
        h = h * 17 + this.byteSize;
        h = h * 17 + this.datasetUri.hashCode();
        h = h * 17 + this.description.hashCode();
        h = h * 17 + this.downloadURL.hashCode();
        h = h * 17 + this.format.hashCode();
        h = h * 17 + this.issued.hashCode();
        h = h * 17 + this.language.hashCode();
        h = h * 17 + this.license.hashCode();
        h = h * 17 + this.mediaType.hashCode();
        h = h * 17 + this.modified.hashCode();
        h = h * 17 + this.rights.hashCode();
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DcatDistribution").add("accessURL", (Object)this.accessURL).add("byteSize", this.byteSize).add("datasetUri", (Object)this.datasetUri).add("description", (Object)this.description).add("downloadURL", (Object)this.downloadURL).add("format", (Object)this.format).add("issued", (Object)this.issued).add("language", (Object)this.language).add("license", (Object)this.license).add("mediaType", (Object)this.mediaType).add("modified", (Object)this.modified).add("rights", (Object)this.rights).add("title", (Object)this.title).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator
    static DcatDistribution fromJson(Json json) {
        Builder builder = DcatDistribution.builder();
        if (json.accessURL != null) {
            builder.setAccessURL(json.accessURL);
        }
        if (json.byteSize != null) {
            builder.setByteSize(json.byteSize);
        }
        if (json.datasetUri != null) {
            builder.setDatasetUri(json.datasetUri);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.downloadURL != null) {
            builder.setDownloadURL(json.downloadURL);
        }
        if (json.format != null) {
            builder.setFormat(json.format);
        }
        if (json.issued != null) {
            builder.setIssued(json.issued);
        }
        if (json.language != null) {
            builder.setLanguage(json.language);
        }
        if (json.license != null) {
            builder.setLicense(json.license);
        }
        if (json.mediaType != null) {
            builder.setMediaType(json.mediaType);
        }
        if (json.modified != null) {
            builder.setModified(json.modified);
        }
        if (json.rights != null) {
            builder.setRights(json.rights);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        return builder.build();
    }

    public static DcatDistribution of() {
        return INSTANCE;
    }

    private static DcatDistribution validate(DcatDistribution instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static DcatDistribution copyOf(DcatDistribution instance) {
        if (instance instanceof DcatDistribution) {
            return instance;
        }
        return DcatDistribution.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return DcatDistribution.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_BYTE_SIZE = 1L;
        private long optBits;
        @Nullable
        private String accessURL;
        private int byteSize;
        @Nullable
        private String datasetUri;
        @Nullable
        private Dict description;
        @Nullable
        private String downloadURL;
        @Nullable
        private String format;
        @Nullable
        private String issued;
        @Nullable
        private Locale language;
        @Nullable
        private String license;
        @Nullable
        private String mediaType;
        @Nullable
        private String modified;
        @Nullable
        private String rights;
        @Nullable
        private Dict title;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(DcatDistribution instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setAccessURL(instance.getAccessURL());
            this.setByteSize(instance.getByteSize());
            this.setDatasetUri(instance.getDatasetUri());
            this.setDescription(instance.getDescription());
            this.setDownloadURL(instance.getDownloadURL());
            this.setFormat(instance.getFormat());
            this.setIssued(instance.getIssued());
            this.setLanguage(instance.getLanguage());
            this.setLicense(instance.getLicense());
            this.setMediaType(instance.getMediaType());
            this.setModified(instance.getModified());
            this.setRights(instance.getRights());
            this.setTitle(instance.getTitle());
            this.setUri(instance.getUri());
            return this;
        }

        public final Builder setAccessURL(String accessURL) {
            this.accessURL = (String)Preconditions.checkNotNull((Object)accessURL);
            return this;
        }

        public final Builder setByteSize(int byteSize) {
            this.byteSize = byteSize;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setDatasetUri(String datasetUri) {
            this.datasetUri = (String)Preconditions.checkNotNull((Object)datasetUri);
            return this;
        }

        public final Builder setDescription(Dict description) {
            this.description = (Dict)Preconditions.checkNotNull((Object)description);
            return this;
        }

        public final Builder setDownloadURL(String downloadURL) {
            this.downloadURL = (String)Preconditions.checkNotNull((Object)downloadURL);
            return this;
        }

        public final Builder setFormat(String format) {
            this.format = (String)Preconditions.checkNotNull((Object)format);
            return this;
        }

        public final Builder setIssued(String issued) {
            this.issued = (String)Preconditions.checkNotNull((Object)issued);
            return this;
        }

        public final Builder setLanguage(Locale language) {
            this.language = (Locale)Preconditions.checkNotNull((Object)language);
            return this;
        }

        public final Builder setLicense(String license) {
            this.license = (String)Preconditions.checkNotNull((Object)license);
            return this;
        }

        public final Builder setMediaType(String mediaType) {
            this.mediaType = (String)Preconditions.checkNotNull((Object)mediaType);
            return this;
        }

        public final Builder setModified(String modified) {
            this.modified = (String)Preconditions.checkNotNull((Object)modified);
            return this;
        }

        public final Builder setRights(String rights) {
            this.rights = (String)Preconditions.checkNotNull((Object)rights);
            return this;
        }

        public final Builder setTitle(Dict title) {
            this.title = (Dict)Preconditions.checkNotNull((Object)title);
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public DcatDistribution build() throws IllegalStateException {
            return DcatDistribution.validate(new DcatDistribution(this));
        }

        private boolean byteSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String accessURL;
        @JsonProperty
        @Nullable
        Integer byteSize;
        @JsonProperty
        @Nullable
        String datasetUri;
        @JsonProperty
        @Nullable
        Dict description;
        @JsonProperty
        @Nullable
        String downloadURL;
        @JsonProperty
        @Nullable
        String format;
        @JsonProperty
        @Nullable
        String issued;
        @JsonProperty
        @Nullable
        Locale language;
        @JsonProperty
        @Nullable
        String license;
        @JsonProperty
        @Nullable
        String mediaType;
        @JsonProperty
        @Nullable
        String modified;
        @JsonProperty
        @Nullable
        String rights;
        @JsonProperty
        @Nullable
        Dict title;
        @JsonProperty
        @Nullable
        String uri;

        Json() {
        }
    }

    private final class InitShim {
        private String accessURL;
        private byte accessURLStage;
        private int byteSize;
        private byte byteSizeStage;
        private String datasetUri;
        private byte datasetUriStage;
        private Dict description;
        private byte descriptionStage;
        private String downloadURL;
        private byte downloadURLStage;
        private String format;
        private byte formatStage;
        private String issued;
        private byte issuedStage;
        private Locale language;
        private byte languageStage;
        private String license;
        private byte licenseStage;
        private String mediaType;
        private byte mediaTypeStage;
        private String modified;
        private byte modifiedStage;
        private String rights;
        private byte rightsStage;
        private Dict title;
        private byte titleStage;
        private String uri;
        private byte uriStage;

        private InitShim() {
        }

        String getAccessURL() {
            if (this.accessURLStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.accessURLStage == 0) {
                this.accessURLStage = (byte)-1;
                this.accessURL = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getAccessURL());
                this.accessURLStage = 1;
            }
            return this.accessURL;
        }

        String setAccessURL(String value) {
            this.accessURL = value;
            this.accessURLStage = 1;
            return value;
        }

        int getByteSize() {
            if (this.byteSizeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.byteSizeStage == 0) {
                this.byteSizeStage = (byte)-1;
                this.byteSize = DcatDistribution.super.getByteSize();
                this.byteSizeStage = 1;
            }
            return this.byteSize;
        }

        int setByteSize(int value) {
            this.byteSize = value;
            this.byteSizeStage = 1;
            return value;
        }

        String getDatasetUri() {
            if (this.datasetUriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.datasetUriStage == 0) {
                this.datasetUriStage = (byte)-1;
                this.datasetUri = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getDatasetUri());
                this.datasetUriStage = 1;
            }
            return this.datasetUri;
        }

        String setDatasetUri(String value) {
            this.datasetUri = value;
            this.datasetUriStage = 1;
            return value;
        }

        Dict getDescription() {
            if (this.descriptionStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionStage == 0) {
                this.descriptionStage = (byte)-1;
                this.description = (Dict)Preconditions.checkNotNull((Object)DcatDistribution.super.getDescription());
                this.descriptionStage = 1;
            }
            return this.description;
        }

        Dict setDescription(Dict value) {
            this.description = value;
            this.descriptionStage = 1;
            return value;
        }

        String getDownloadURL() {
            if (this.downloadURLStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.downloadURLStage == 0) {
                this.downloadURLStage = (byte)-1;
                this.downloadURL = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getDownloadURL());
                this.downloadURLStage = 1;
            }
            return this.downloadURL;
        }

        String setDownloadURL(String value) {
            this.downloadURL = value;
            this.downloadURLStage = 1;
            return value;
        }

        String getFormat() {
            if (this.formatStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.formatStage == 0) {
                this.formatStage = (byte)-1;
                this.format = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getFormat());
                this.formatStage = 1;
            }
            return this.format;
        }

        String setFormat(String value) {
            this.format = value;
            this.formatStage = 1;
            return value;
        }

        String getIssued() {
            if (this.issuedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.issuedStage == 0) {
                this.issuedStage = (byte)-1;
                this.issued = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getIssued());
                this.issuedStage = 1;
            }
            return this.issued;
        }

        String setIssued(String value) {
            this.issued = value;
            this.issuedStage = 1;
            return value;
        }

        Locale getLanguage() {
            if (this.languageStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.languageStage == 0) {
                this.languageStage = (byte)-1;
                this.language = (Locale)Preconditions.checkNotNull((Object)DcatDistribution.super.getLanguage());
                this.languageStage = 1;
            }
            return this.language;
        }

        Locale setLanguage(Locale value) {
            this.language = value;
            this.languageStage = 1;
            return value;
        }

        String getLicense() {
            if (this.licenseStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.licenseStage == 0) {
                this.licenseStage = (byte)-1;
                this.license = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getLicense());
                this.licenseStage = 1;
            }
            return this.license;
        }

        String setLicense(String value) {
            this.license = value;
            this.licenseStage = 1;
            return value;
        }

        String getMediaType() {
            if (this.mediaTypeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mediaTypeStage == 0) {
                this.mediaTypeStage = (byte)-1;
                this.mediaType = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getMediaType());
                this.mediaTypeStage = 1;
            }
            return this.mediaType;
        }

        String setMediaType(String value) {
            this.mediaType = value;
            this.mediaTypeStage = 1;
            return value;
        }

        String getModified() {
            if (this.modifiedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedStage == 0) {
                this.modifiedStage = (byte)-1;
                this.modified = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getModified());
                this.modifiedStage = 1;
            }
            return this.modified;
        }

        String setModified(String value) {
            this.modified = value;
            this.modifiedStage = 1;
            return value;
        }

        String getRights() {
            if (this.rightsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rightsStage == 0) {
                this.rightsStage = (byte)-1;
                this.rights = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getRights());
                this.rightsStage = 1;
            }
            return this.rights;
        }

        String setRights(String value) {
            this.rights = value;
            this.rightsStage = 1;
            return value;
        }

        Dict getTitle() {
            if (this.titleStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.titleStage == 0) {
                this.titleStage = (byte)-1;
                this.title = (Dict)Preconditions.checkNotNull((Object)DcatDistribution.super.getTitle());
                this.titleStage = 1;
            }
            return this.title;
        }

        Dict setTitle(Dict value) {
            this.title = value;
            this.titleStage = 1;
            return value;
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)DcatDistribution.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.accessURLStage == -1) {
                attributes.add("accessURL");
            }
            if (this.byteSizeStage == -1) {
                attributes.add("byteSize");
            }
            if (this.datasetUriStage == -1) {
                attributes.add("datasetUri");
            }
            if (this.descriptionStage == -1) {
                attributes.add("description");
            }
            if (this.downloadURLStage == -1) {
                attributes.add("downloadURL");
            }
            if (this.formatStage == -1) {
                attributes.add("format");
            }
            if (this.issuedStage == -1) {
                attributes.add("issued");
            }
            if (this.languageStage == -1) {
                attributes.add("language");
            }
            if (this.licenseStage == -1) {
                attributes.add("license");
            }
            if (this.mediaTypeStage == -1) {
                attributes.add("mediaType");
            }
            if (this.modifiedStage == -1) {
                attributes.add("modified");
            }
            if (this.rightsStage == -1) {
                attributes.add("rights");
            }
            if (this.titleStage == -1) {
                attributes.add("title");
            }
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            return "Cannot build DcatDistribution, attribute initializers form cycle" + attributes;
        }
    }
}

