/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.traceprov.dcat.AFoafAgent;
import eu.trentorise.opendata.traceprov.dcat.AFoafOrganization;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class FoafOrganization
extends AFoafOrganization {
    private final String mbox;
    private final String homepage;
    private final Dict name;
    private final String uri;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final FoafOrganization INSTANCE = FoafOrganization.validate(new FoafOrganization());
    private static final long serialVersionUID = 1L;

    private FoafOrganization() {
        this.mbox = this.initShim.getMbox();
        this.homepage = this.initShim.getHomepage();
        this.name = this.initShim.getName();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private FoafOrganization(Builder builder) {
        if (builder.mbox != null) {
            this.initShim.setMbox(builder.mbox);
        }
        if (builder.homepage != null) {
            this.initShim.setHomepage(builder.homepage);
        }
        if (builder.name != null) {
            this.initShim.setName(builder.name);
        }
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        this.mbox = this.initShim.getMbox();
        this.homepage = this.initShim.getHomepage();
        this.name = this.initShim.getName();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private FoafOrganization(String mbox, String homepage, Dict name, String uri) {
        this.mbox = mbox;
        this.homepage = homepage;
        this.name = name;
        this.uri = uri;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getMbox() {
        return this.initShim != null ? this.initShim.getMbox() : this.mbox;
    }

    @Override
    @JsonProperty
    public String getHomepage() {
        return this.initShim != null ? this.initShim.getHomepage() : this.homepage;
    }

    @Override
    @JsonProperty
    public Dict getName() {
        return this.initShim != null ? this.initShim.getName() : this.name;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    public final FoafOrganization withMbox(String value) {
        if (this.mbox == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return FoafOrganization.validate(new FoafOrganization(newValue, this.homepage, this.name, this.uri));
    }

    public final FoafOrganization withHomepage(String value) {
        if (this.homepage == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return FoafOrganization.validate(new FoafOrganization(this.mbox, newValue, this.name, this.uri));
    }

    public final FoafOrganization withName(Dict value) {
        if (this.name == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return FoafOrganization.validate(new FoafOrganization(this.mbox, this.homepage, newValue, this.uri));
    }

    public final FoafOrganization withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return FoafOrganization.validate(new FoafOrganization(this.mbox, this.homepage, this.name, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FoafOrganization && this.equalTo((FoafOrganization)another);
    }

    private boolean equalTo(FoafOrganization another) {
        return this.mbox.equals(another.mbox) && this.homepage.equals(another.homepage) && this.name.equals((Object)another.name) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.mbox.hashCode();
        h = h * 17 + this.homepage.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FoafOrganization").add("mbox", (Object)this.mbox).add("homepage", (Object)this.homepage).add("name", (Object)this.name).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator
    static FoafOrganization fromJson(Json json) {
        Builder builder = FoafOrganization.builder();
        if (json.mbox != null) {
            builder.setMbox(json.mbox);
        }
        if (json.homepage != null) {
            builder.setHomepage(json.homepage);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        return builder.build();
    }

    public static FoafOrganization of() {
        return INSTANCE;
    }

    private static FoafOrganization validate(FoafOrganization instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static FoafOrganization copyOf(FoafOrganization instance) {
        if (instance instanceof FoafOrganization) {
            return instance;
        }
        return FoafOrganization.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return FoafOrganization.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String mbox;
        @Nullable
        private String homepage;
        @Nullable
        private Dict name;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(AFoafAgent instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FoafOrganization instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AFoafAgent) {
                AFoafAgent instance = (AFoafAgent)object;
                this.setUri(instance.getUri());
                this.setHomepage(instance.getHomepage());
                this.setMbox(instance.getMbox());
                this.setName(instance.getName());
            }
        }

        public final Builder setMbox(String mbox) {
            this.mbox = (String)Preconditions.checkNotNull((Object)mbox);
            return this;
        }

        public final Builder setHomepage(String homepage) {
            this.homepage = (String)Preconditions.checkNotNull((Object)homepage);
            return this;
        }

        public final Builder setName(Dict name) {
            this.name = (Dict)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public FoafOrganization build() throws IllegalStateException {
            return FoafOrganization.validate(new FoafOrganization(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String mbox;
        @JsonProperty
        @Nullable
        String homepage;
        @JsonProperty
        @Nullable
        Dict name;
        @JsonProperty
        @Nullable
        String uri;

        Json() {
        }
    }

    private final class InitShim {
        private String mbox;
        private byte mboxStage;
        private String homepage;
        private byte homepageStage;
        private Dict name;
        private byte nameStage;
        private String uri;
        private byte uriStage;

        private InitShim() {
        }

        String getMbox() {
            if (this.mboxStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mboxStage == 0) {
                this.mboxStage = (byte)-1;
                this.mbox = (String)Preconditions.checkNotNull((Object)FoafOrganization.super.getMbox());
                this.mboxStage = 1;
            }
            return this.mbox;
        }

        String setMbox(String value) {
            this.mbox = value;
            this.mboxStage = 1;
            return value;
        }

        String getHomepage() {
            if (this.homepageStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.homepageStage == 0) {
                this.homepageStage = (byte)-1;
                this.homepage = (String)Preconditions.checkNotNull((Object)FoafOrganization.super.getHomepage());
                this.homepageStage = 1;
            }
            return this.homepage;
        }

        String setHomepage(String value) {
            this.homepage = value;
            this.homepageStage = 1;
            return value;
        }

        Dict getName() {
            if (this.nameStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameStage == 0) {
                this.nameStage = (byte)-1;
                this.name = (Dict)Preconditions.checkNotNull((Object)FoafOrganization.super.getName());
                this.nameStage = 1;
            }
            return this.name;
        }

        Dict setName(Dict value) {
            this.name = value;
            this.nameStage = 1;
            return value;
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)FoafOrganization.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.mboxStage == -1) {
                attributes.add("mbox");
            }
            if (this.homepageStage == -1) {
                attributes.add("homepage");
            }
            if (this.nameStage == -1) {
                attributes.add("name");
            }
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            return "Cannot build FoafOrganization, attribute initializers form cycle" + attributes;
        }
    }
}

