/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import eu.trentorise.opendata.traceprov.geojson.AGeometry;
import eu.trentorise.opendata.traceprov.geojson.MultiPolygon;
import eu.trentorise.opendata.traceprov.validation.Preconditions;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=MultiPolygon.class)
@JsonDeserialize(as=MultiPolygon.class)
@Value.Immutable
abstract class AMultiPolygon
extends AGeometry {
    private static final long serialVersionUID = 1L;

    AMultiPolygon() {
    }

    public abstract ImmutableList<ImmutableList<ImmutableList<ImmutableList<Double>>>> getCoordinates();

    @Value.Check
    protected void check() {
        for (ImmutableList polygon : this.getCoordinates()) {
            Preconditions.checkPolygon((List<ImmutableList<ImmutableList<Double>>>)polygon, "Invalid polygon!");
        }
    }
}

