/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import eu.trentorise.opendata.traceprov.geojson.AGeometry;
import eu.trentorise.opendata.traceprov.geojson.AGeometryCollection;
import eu.trentorise.opendata.traceprov.geojson.Crs;
import eu.trentorise.opendata.traceprov.geojson.GeoJson;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class GeometryCollection
extends AGeometryCollection {
    private final ImmutableList<AGeometry> geometries;
    private final String type;
    private final ImmutableList<Double> bbox;
    @Nullable
    private final Crs crs;
    private static final GeometryCollection INSTANCE = GeometryCollection.validate(new GeometryCollection());
    private static final long serialVersionUID = 1L;

    private GeometryCollection() {
        this.geometries = ImmutableList.of();
        this.bbox = ImmutableList.of();
        this.crs = null;
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
    }

    private GeometryCollection(ImmutableList<AGeometry> geometries, ImmutableList<Double> bbox, @Nullable Crs crs) {
        this.geometries = geometries;
        this.bbox = bbox;
        this.crs = crs;
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
    }

    @JsonProperty
    public ImmutableList<AGeometry> getGeometries() {
        return this.geometries;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public ImmutableList<Double> getBbox() {
        return this.bbox;
    }

    @Override
    @JsonProperty
    @Nullable
    public Crs getCrs() {
        return this.crs;
    }

    public final GeometryCollection withGeometries(AGeometry ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return GeometryCollection.validate(new GeometryCollection((ImmutableList<AGeometry>)newValue, this.bbox, this.crs));
    }

    public final GeometryCollection withGeometries(Iterable<? extends AGeometry> elements) {
        if (this.geometries == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return GeometryCollection.validate(new GeometryCollection((ImmutableList<AGeometry>)newValue, this.bbox, this.crs));
    }

    public final GeometryCollection withBbox(double ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Doubles.asList((double[])elements));
        return GeometryCollection.validate(new GeometryCollection(this.geometries, (ImmutableList<Double>)newValue, this.crs));
    }

    public final GeometryCollection withBbox(Iterable<Double> elements) {
        if (this.bbox == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return GeometryCollection.validate(new GeometryCollection(this.geometries, (ImmutableList<Double>)newValue, this.crs));
    }

    public final GeometryCollection withCrs(@Nullable Crs value) {
        if (this.crs == value) {
            return this;
        }
        Crs newValue = value;
        return GeometryCollection.validate(new GeometryCollection(this.geometries, this.bbox, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GeometryCollection && this.equalTo((GeometryCollection)another);
    }

    private boolean equalTo(GeometryCollection another) {
        return this.geometries.equals(another.geometries) && this.type.equals(another.type) && this.bbox.equals(another.bbox) && Objects.equal((Object)this.crs, (Object)another.crs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.geometries.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.bbox.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.crs});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GeometryCollection").add("geometries", this.geometries).add("type", (Object)this.type).add("bbox", this.bbox).add("crs", (Object)this.crs).toString();
    }

    @Deprecated
    @JsonCreator
    static GeometryCollection fromJson(Json json) {
        Builder builder = GeometryCollection.builder();
        if (json.geometries != null) {
            builder.addAllGeometries(json.geometries);
        }
        if (json.bbox != null) {
            builder.addAllBbox(json.bbox);
        }
        if (json.crs != null) {
            builder.setCrs(json.crs);
        }
        return builder.build();
    }

    public static GeometryCollection of() {
        return INSTANCE;
    }

    private static GeometryCollection validate(GeometryCollection instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static GeometryCollection copyOf(GeometryCollection instance) {
        if (instance instanceof GeometryCollection) {
            return instance;
        }
        return GeometryCollection.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return GeometryCollection.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<AGeometry> geometriesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<Double> bboxBuilder = ImmutableList.builder();
        @Nullable
        private Crs crs;

        private Builder() {
        }

        public final Builder from(GeometryCollection instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GeoJson instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GeoJson instance;
            if (object instanceof AGeometryCollection) {
                instance = (AGeometryCollection)object;
                this.addAllGeometries(((AGeometryCollection)instance).getGeometries());
            }
            if (object instanceof GeoJson) {
                instance = (GeoJson)object;
                Crs crsValue = instance.getCrs();
                if (crsValue != null) {
                    this.setCrs(crsValue);
                }
                this.addAllBbox(instance.getBbox());
            }
        }

        public final Builder addGeometries(AGeometry element) {
            this.geometriesBuilder.add((Object)element);
            return this;
        }

        public final Builder addGeometries(AGeometry ... elements) {
            this.geometriesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setGeometries(Iterable<? extends AGeometry> elements) {
            this.geometriesBuilder = ImmutableList.builder();
            return this.addAllGeometries(elements);
        }

        public final Builder addAllGeometries(Iterable<? extends AGeometry> elements) {
            this.geometriesBuilder.addAll(elements);
            return this;
        }

        public final Builder addBbox(double element) {
            this.bboxBuilder.add((Object)element);
            return this;
        }

        public final Builder addBbox(double ... elements) {
            this.bboxBuilder.addAll((Iterable)Doubles.asList((double[])elements));
            return this;
        }

        public final Builder setBbox(Iterable<Double> elements) {
            this.bboxBuilder = ImmutableList.builder();
            return this.addAllBbox(elements);
        }

        public final Builder addAllBbox(Iterable<Double> elements) {
            this.bboxBuilder.addAll(elements);
            return this;
        }

        public final Builder setCrs(@Nullable Crs crs) {
            this.crs = crs;
            return this;
        }

        public GeometryCollection build() throws IllegalStateException {
            return GeometryCollection.validate(new GeometryCollection(this.geometriesBuilder.build(), this.bboxBuilder.build(), this.crs));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        List<AGeometry> geometries;
        @JsonProperty
        @Nullable
        String type;
        @JsonProperty
        @Nullable
        List<Double> bbox;
        @JsonProperty
        @Nullable
        Crs crs;

        Json() {
        }
    }
}

