/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import eu.trentorise.opendata.traceprov.geojson.AGeometry;
import eu.trentorise.opendata.traceprov.geojson.AMultiPoint;
import eu.trentorise.opendata.traceprov.geojson.Crs;
import eu.trentorise.opendata.traceprov.geojson.GeoJson;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class MultiPoint
extends AMultiPoint {
    private final ImmutableList<ImmutableList<Double>> coordinates;
    private final String type;
    private final ImmutableList<Double> bbox;
    @Nullable
    private final Crs crs;
    private static final MultiPoint INSTANCE = MultiPoint.validate(new MultiPoint());
    private static final long serialVersionUID = 1L;

    private MultiPoint() {
        this.coordinates = ImmutableList.of();
        this.bbox = ImmutableList.of();
        this.crs = null;
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
    }

    private MultiPoint(ImmutableList<ImmutableList<Double>> coordinates, ImmutableList<Double> bbox, @Nullable Crs crs) {
        this.coordinates = coordinates;
        this.bbox = bbox;
        this.crs = crs;
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
    }

    @Override
    @JsonProperty
    public ImmutableList<ImmutableList<Double>> getCoordinates() {
        return this.coordinates;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public ImmutableList<Double> getBbox() {
        return this.bbox;
    }

    @Override
    @JsonProperty
    @Nullable
    public Crs getCrs() {
        return this.crs;
    }

    @SafeVarargs
    public final MultiPoint withCoordinates(ImmutableList<Double> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return MultiPoint.validate(new MultiPoint((ImmutableList<ImmutableList<Double>>)newValue, this.bbox, this.crs));
    }

    public final MultiPoint withCoordinates(Iterable<? extends ImmutableList<Double>> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return MultiPoint.validate(new MultiPoint((ImmutableList<ImmutableList<Double>>)newValue, this.bbox, this.crs));
    }

    public final MultiPoint withBbox(double ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Doubles.asList((double[])elements));
        return MultiPoint.validate(new MultiPoint(this.coordinates, (ImmutableList<Double>)newValue, this.crs));
    }

    public final MultiPoint withBbox(Iterable<Double> elements) {
        if (this.bbox == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return MultiPoint.validate(new MultiPoint(this.coordinates, (ImmutableList<Double>)newValue, this.crs));
    }

    public final MultiPoint withCrs(@Nullable Crs value) {
        if (this.crs == value) {
            return this;
        }
        Crs newValue = value;
        return MultiPoint.validate(new MultiPoint(this.coordinates, this.bbox, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MultiPoint && this.equalTo((MultiPoint)another);
    }

    private boolean equalTo(MultiPoint another) {
        return this.coordinates.equals(another.coordinates) && this.type.equals(another.type) && this.bbox.equals(another.bbox) && Objects.equal((Object)this.crs, (Object)another.crs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.coordinates.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.bbox.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.crs});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MultiPoint").add("coordinates", this.coordinates).add("type", (Object)this.type).add("bbox", this.bbox).add("crs", (Object)this.crs).toString();
    }

    @Deprecated
    @JsonCreator
    static MultiPoint fromJson(Json json) {
        Builder builder = MultiPoint.builder();
        if (json.coordinates != null) {
            builder.addAllCoordinates((Iterable<? extends ImmutableList<Double>>)json.coordinates);
        }
        if (json.bbox != null) {
            builder.addAllBbox(json.bbox);
        }
        if (json.crs != null) {
            builder.setCrs(json.crs);
        }
        return builder.build();
    }

    public static MultiPoint of() {
        return INSTANCE;
    }

    private static MultiPoint validate(MultiPoint instance) {
        instance.check();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static MultiPoint copyOf(MultiPoint instance) {
        if (instance instanceof MultiPoint) {
            return instance;
        }
        return MultiPoint.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return MultiPoint.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<ImmutableList<Double>> coordinatesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<Double> bboxBuilder = ImmutableList.builder();
        @Nullable
        private Crs crs;

        private Builder() {
        }

        public final Builder from(MultiPoint instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GeoJson instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AGeometry instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GeoJson instance;
            long bits = 0L;
            if (object instanceof AMultiPoint) {
                instance = (AMultiPoint)object;
                if ((bits & 1L) == 0L) {
                    this.addAllCoordinates((Iterable<? extends ImmutableList<Double>>)((AMultiPoint)instance).getCoordinates());
                    bits |= 1L;
                }
            }
            if (object instanceof GeoJson) {
                instance = (GeoJson)object;
                Crs crsValue = instance.getCrs();
                if (crsValue != null) {
                    this.setCrs(crsValue);
                }
                this.addAllBbox(instance.getBbox());
            }
            if (object instanceof AGeometry) {
                instance = (AGeometry)object;
                if ((bits & 1L) == 0L) {
                    this.addAllCoordinates(((AGeometry)instance).getCoordinates());
                    bits |= 1L;
                }
            }
        }

        public final Builder addCoordinates(ImmutableList<Double> element) {
            this.coordinatesBuilder.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder addCoordinates(ImmutableList<Double> ... elements) {
            this.coordinatesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setCoordinates(Iterable<? extends ImmutableList<Double>> elements) {
            this.coordinatesBuilder = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        public final Builder addAllCoordinates(Iterable<? extends ImmutableList<Double>> elements) {
            this.coordinatesBuilder.addAll(elements);
            return this;
        }

        public final Builder addBbox(double element) {
            this.bboxBuilder.add((Object)element);
            return this;
        }

        public final Builder addBbox(double ... elements) {
            this.bboxBuilder.addAll((Iterable)Doubles.asList((double[])elements));
            return this;
        }

        public final Builder setBbox(Iterable<Double> elements) {
            this.bboxBuilder = ImmutableList.builder();
            return this.addAllBbox(elements);
        }

        public final Builder addAllBbox(Iterable<Double> elements) {
            this.bboxBuilder.addAll(elements);
            return this;
        }

        public final Builder setCrs(@Nullable Crs crs) {
            this.crs = crs;
            return this;
        }

        public MultiPoint build() throws IllegalStateException {
            return MultiPoint.validate(new MultiPoint(this.coordinatesBuilder.build(), this.bboxBuilder.build(), this.crs));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        ImmutableList<ImmutableList<Double>> coordinates;
        @JsonProperty
        @Nullable
        String type;
        @JsonProperty
        @Nullable
        List<Double> bbox;
        @JsonProperty
        @Nullable
        Crs crs;

        Json() {
        }
    }
}

