/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.validation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkPosition(List<Double> position, @Nullable Object prependedErrorMessage) {
        com.google.common.base.Preconditions.checkNotNull(position, (Object)(String.valueOf(prependedErrorMessage) + " - " + prependedErrorMessage));
        if (position.size() < 2) {
            throw new IllegalStateException(String.valueOf(prependedErrorMessage) + "Found " + position.size() + " coordinates, required at least 2 ");
        }
        for (Double d : position) {
            com.google.common.base.Preconditions.checkNotNull((Object)d, (Object)(String.valueOf(prependedErrorMessage) + "Found null in coordinate!"));
        }
    }

    public static void checkPositions(List<ImmutableList<Double>> positions, int min, @Nullable Object prependedErrorMessage) {
        com.google.common.base.Preconditions.checkNotNull(positions, (Object)String.valueOf(prependedErrorMessage));
        com.google.common.base.Preconditions.checkArgument((positions.size() >= min ? 1 : 0) != 0, (String)(String.valueOf(prependedErrorMessage) + "At least %s positions are required, found instead %s"), (Object[])new Object[]{min, positions.size()});
        for (int i = 0; i < positions.size(); ++i) {
            List c = (List)positions.get(i);
            Preconditions.checkPosition(c, String.valueOf(prependedErrorMessage) + " - Wrong position at index " + i + ".");
        }
    }

    public static void checkPolygon(List<ImmutableList<ImmutableList<Double>>> positions, @Nullable Object prependedErrorMessage) {
        com.google.common.base.Preconditions.checkNotNull(positions, (Object)(String.valueOf(prependedErrorMessage) + " - " + prependedErrorMessage));
        for (ImmutableList<ImmutableList<Double>> lst : positions) {
            Preconditions.checkPositions(lst, 4, String.valueOf(prependedErrorMessage) + " - Invalid polygon!");
        }
    }
}

