/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard;

import io.dropwizard.Configuration;
import io.dropwizard.cli.CheckCommand;
import io.dropwizard.cli.Cli;
import io.dropwizard.cli.ServerCommand;
import io.dropwizard.logging.LoggingFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Generics;
import io.dropwizard.util.JarLocation;

public abstract class Application<T extends Configuration> {
    public final Class<T> getConfigurationClass() {
        return Generics.getTypeParameter(this.getClass(), Configuration.class);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract void initialize(Bootstrap<T> var1);

    public abstract void run(T var1, Environment var2) throws Exception;

    public final void run(String[] arguments) throws Exception {
        Bootstrap bootstrap = new Bootstrap(this);
        bootstrap.addCommand(new ServerCommand(this));
        bootstrap.addCommand(new CheckCommand(this));
        this.initialize(bootstrap);
        Cli cli = new Cli(new JarLocation(this.getClass()), bootstrap, System.out, System.err);
        if (!cli.run(arguments)) {
            System.exit(1);
        }
    }

    static {
        LoggingFactory.bootstrap();
    }
}

