/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.dynamic.CommandCreationException;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.CommandSegmentCommandFactory;
import io.lettuce.core.dynamic.output.CommandOutputFactory;
import io.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import io.lettuce.core.dynamic.output.OutputSelector;
import io.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import io.lettuce.core.dynamic.segment.CommandSegments;

class ReactiveCommandSegmentCommandFactory
extends CommandSegmentCommandFactory {
    private boolean streamingExecution;

    public ReactiveCommandSegmentCommandFactory(CommandSegments commandSegments, CommandMethod commandMethod, RedisCodec<?, ?> redisCodec, CommandOutputFactoryResolver outputResolver) {
        super(commandSegments, commandMethod, redisCodec, outputResolver);
        ExecutionSpecificParameters executionAwareParameters;
        if (commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionAwareParameters = (ExecutionSpecificParameters)commandMethod.getParameters()).hasTimeoutIndex()) {
            throw new CommandCreationException(commandMethod, "Reactive command methods do not support Timeout parameters");
        }
    }

    @Override
    protected CommandOutputFactory resolveCommandOutputFactory(OutputSelector outputSelector) {
        CommandOutputFactory factory = this.getOutputResolver().resolveStreamingCommandOutput(outputSelector);
        if (factory != null) {
            this.streamingExecution = true;
            return factory;
        }
        return super.resolveCommandOutputFactory(outputSelector);
    }

    public boolean isStreamingExecution() {
        return this.streamingExecution;
    }
}

