/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.jboss.crypto.JBossSXProvider;
import org.jboss.logging.Logger;
import org.jboss.security.Base64Encoder;

public class Util {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$Util == null ? (class$org$jboss$security$Util = Util.class$("org.jboss.security.Util")) : class$org$jboss$security$Util));
    private static final int HASH_LEN = 20;
    private static final char[] base64Table = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./".toCharArray();
    public static final String BASE64_ENCODING = "BASE64";
    public static final String BASE16_ENCODING = "HEX";
    private static SecureRandom psuedoRng;
    private static MessageDigest sha1Digest;
    private static boolean initialized;
    static /* synthetic */ Class class$org$jboss$security$Util;
    static /* synthetic */ Class class$java$lang$String;

    public static void init() throws NoSuchAlgorithmException {
        if (initialized) {
            return;
        }
        Util.init(null);
    }

    public static void init(byte[] prngSeed) throws NoSuchAlgorithmException {
        sha1Digest = MessageDigest.getInstance("SHA");
        psuedoRng = SecureRandom.getInstance("SHA1PRNG");
        if (prngSeed != null) {
            psuedoRng.setSeed(prngSeed);
        }
        JBossSXProvider provider = new JBossSXProvider();
        Security.addProvider(provider);
        initialized = true;
    }

    public static MessageDigest newDigest() {
        MessageDigest md = null;
        try {
            md = (MessageDigest)sha1Digest.clone();
        }
        catch (CloneNotSupportedException e) {}
        return md;
    }

    public static MessageDigest copy(MessageDigest md) {
        MessageDigest copy = null;
        try {
            copy = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {}
        return copy;
    }

    public static Random getPRNG() {
        return psuedoRng;
    }

    public static double nextDouble() {
        return psuedoRng.nextDouble();
    }

    public static long nextLong() {
        return psuedoRng.nextLong();
    }

    public static void nextBytes(byte[] bytes) {
        psuedoRng.nextBytes(bytes);
    }

    public static byte[] generateSeed(int numBytes) {
        return psuedoRng.generateSeed(numBytes);
    }

    public static byte[] calculatePasswordHash(String username, char[] password, byte[] salt) {
        MessageDigest xd = Util.newDigest();
        byte[] user = null;
        byte[] colon = new byte[]{};
        try {
            user = username.getBytes("UTF-8");
            colon = ":".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Failed to convert username to byte[] using UTF-8", (Throwable)e);
            user = username.getBytes();
            colon = ":".getBytes();
        }
        byte[] passBytes = new byte[2 * password.length];
        int passBytesLength = 0;
        int p = 0;
        while (p < password.length) {
            int c = password[p] & 0xFFFF;
            byte b0 = (byte)(c & 0xFF);
            byte b1 = (byte)((c & 0xFF00) >> 8);
            passBytes[passBytesLength++] = b0;
            if (c > 255) {
                passBytes[passBytesLength++] = b1;
            }
            ++p;
        }
        xd.update(user);
        xd.update(colon);
        xd.update(passBytes, 0, passBytesLength);
        byte[] h = xd.digest();
        xd.reset();
        xd.update(salt);
        xd.update(h);
        byte[] xb = xd.digest();
        return xb;
    }

    public static byte[] calculateVerifier(String username, char[] password, byte[] salt, byte[] Nb, byte[] gb) {
        BigInteger g = new BigInteger(1, gb);
        BigInteger N = new BigInteger(1, Nb);
        return Util.calculateVerifier(username, password, salt, N, g);
    }

    public static byte[] calculateVerifier(String username, char[] password, byte[] salt, BigInteger N, BigInteger g) {
        byte[] xb = Util.calculatePasswordHash(username, password, salt);
        BigInteger x = new BigInteger(1, xb);
        BigInteger v = g.modPow(x, N);
        return v.toByteArray();
    }

    public static byte[] sessionKeyHash(byte[] number) {
        int offset = 0;
        while (offset < number.length && number[offset] == 0) {
            ++offset;
        }
        byte[] key = new byte[40];
        int klen = (number.length - offset) / 2;
        byte[] hbuf = new byte[klen];
        int i = 0;
        while (i < klen) {
            hbuf[i] = number[number.length - 2 * i - 1];
            ++i;
        }
        byte[] hout = Util.newDigest().digest(hbuf);
        i = 0;
        while (i < 20) {
            key[2 * i] = hout[i];
            ++i;
        }
        i = 0;
        while (i < klen) {
            hbuf[i] = number[number.length - 2 * i - 2];
            ++i;
        }
        hout = Util.newDigest().digest(hbuf);
        i = 0;
        while (i < 20) {
            key[2 * i + 1] = hout[i];
            ++i;
        }
        return key;
    }

    public static byte[] trim(byte[] in) {
        if (in.length == 0 || in[0] != 0) {
            return in;
        }
        int len = in.length;
        int i = 1;
        while (in[i] == 0 && i < len) {
            ++i;
        }
        byte[] ret = new byte[len - i];
        System.arraycopy(in, i, ret, 0, len - i);
        return ret;
    }

    public static byte[] xor(byte[] b1, byte[] b2, int length) {
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[i] = (byte)(b1[i] ^ b2[i]);
            ++i;
        }
        return result;
    }

    public static String encodeBase16(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            char c = (char)(b >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            c = (char)(b & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String encodeBase64(byte[] bytes) {
        String base64 = null;
        try {
            base64 = Base64Encoder.encode(bytes);
        }
        catch (Exception e) {}
        return base64;
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password) {
        String passwordHash;
        block6: {
            byte[] passBytes;
            passwordHash = null;
            try {
                passBytes = hashCharset == null ? password.getBytes() : password.getBytes(hashCharset);
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("charset " + hashCharset + " not found. Using platform default."), (Throwable)uee);
                passBytes = password.getBytes();
            }
            try {
                byte[] hash = MessageDigest.getInstance(hashAlgorithm).digest(passBytes);
                if (hashEncoding.equalsIgnoreCase(BASE64_ENCODING)) {
                    passwordHash = Util.encodeBase64(hash);
                    break block6;
                }
                if (hashEncoding.equalsIgnoreCase(BASE16_ENCODING)) {
                    passwordHash = Util.encodeBase16(hash);
                    break block6;
                }
                log.error((Object)("Unsupported hash encoding format " + hashEncoding));
            }
            catch (Exception e) {
                log.error((Object)"Password hash calculation failed ", (Throwable)e);
            }
        }
        return passwordHash;
    }

    public static String tob64(byte[] buffer) {
        boolean notleading = false;
        int len = buffer.length;
        int pos = len % 3;
        int b0 = 0;
        byte b1 = 0;
        byte b2 = 0;
        StringBuffer sb = new StringBuffer();
        switch (pos) {
            case 1: {
                b2 = buffer[0];
                break;
            }
            case 2: {
                b1 = buffer[0];
                b2 = buffer[1];
            }
        }
        while (true) {
            int c = (b0 & 0xFC) >>> 2;
            if (notleading || c != 0) {
                sb.append(base64Table[c]);
                notleading = true;
            }
            c = (b0 & 3) << 4 | (b1 & 0xF0) >>> 4;
            if (notleading || c != 0) {
                sb.append(base64Table[c]);
                notleading = true;
            }
            c = (b1 & 0xF) << 2 | (b2 & 0xC0) >>> 6;
            if (notleading || c != 0) {
                sb.append(base64Table[c]);
                notleading = true;
            }
            c = b2 & 0x3F;
            if (notleading || c != 0) {
                sb.append(base64Table[c]);
                notleading = true;
            }
            if (pos >= len) break;
            try {
                b0 = buffer[pos++];
                b1 = buffer[pos++];
                b2 = buffer[pos++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        }
        if (notleading) {
            return sb.toString();
        }
        return "0";
    }

    /*
     * Exception decompiling
     */
    public static byte[] fromb64(String str) throws NumberFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 11[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean hasUnlimitedCrypto() {
        boolean hasUnlimitedCrypto = false;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cipherClass = loader.loadClass("javax.crypto.Cipher");
            Class[] sig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Util.class$("java.lang.String")) : class$java$lang$String};
            Class[] sig2 = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{"Blowfish"};
            Object[] args2 = new Object[]{new Integer(256)};
            Method getInstance = cipherClass.getDeclaredMethod("getInstance", sig);
            Method init = cipherClass.getDeclaredMethod("init", sig2);
            Object cipher = getInstance.invoke(null, args);
            init.invoke(cipher, args2);
            hasUnlimitedCrypto = true;
        }
        catch (Throwable e) {
            log.debug((Object)"hasUnlimitedCrypto error", e);
        }
        return hasUnlimitedCrypto;
    }

    public static Object createSecretKey(String cipherAlgorithm, Object key) throws KeyException {
        Class[] signature = new Class[]{key.getClass(), class$java$lang$String == null ? (class$java$lang$String = Util.class$("java.lang.String")) : class$java$lang$String};
        Object[] args = new Object[]{key, cipherAlgorithm};
        Object secretKey = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> secretKeySpecClass = loader.loadClass("javax.crypto.spec.SecretKeySpec");
            Constructor<?> ctor = secretKeySpecClass.getDeclaredConstructor(signature);
            secretKey = ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new KeyException("Failed to create SecretKeySpec from session key, msg=" + e.getMessage());
        }
        catch (Throwable e) {
            throw new KeyException("Unexpected exception during SecretKeySpec creation, msg=" + e.getMessage());
        }
        return secretKey;
    }

    public static Object createSealedObject(String cipherAlgorithm, Object key, byte[] cipherIV, Serializable data) throws GeneralSecurityException {
        SealedObject sealedObject = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKey skey = (SecretKey)key;
            IvParameterSpec iv = new IvParameterSpec(cipherIV);
            cipher.init(1, (Key)skey, iv);
            sealedObject = new SealedObject(data, cipher);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GeneralSecurityException("Failed to create SealedObject, msg=" + e.getMessage());
        }
        return sealedObject;
    }

    public static Object accessSealedObject(String cipherAlgorithm, Object key, byte[] cipherIV, Object obj) throws GeneralSecurityException {
        Object data = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKey skey = (SecretKey)key;
            IvParameterSpec iv = new IvParameterSpec(cipherIV);
            cipher.init(2, (Key)skey, iv);
            SealedObject sealedObj = (SealedObject)obj;
            data = sealedObj.getObject(cipher);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GeneralSecurityException("Failed to access SealedObject, msg=" + e.getMessage());
        }
        return data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

