/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPPermission;

public class SRPServerSession
implements Serializable {
    static final long serialVersionUID = -2448005747721323704L;
    private static int B_LEN = 64;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$srp$SRPServerSession == null ? (class$org$jboss$security$srp$SRPServerSession = SRPServerSession.class$("org.jboss.security.srp.SRPServerSession")) : class$org$jboss$security$srp$SRPServerSession));
    private SRPParameters params;
    private BigInteger N;
    private BigInteger g;
    private BigInteger v;
    private BigInteger b;
    private BigInteger B;
    private byte[] K;
    private transient MessageDigest clientHash;
    private byte[] M1;
    private transient MessageDigest serverHash;
    private byte[] M2;
    static /* synthetic */ Class class$org$jboss$security$srp$SRPServerSession;

    public SRPServerSession(String username, byte[] vb, SRPParameters params) {
        MessageDigest tmp;
        this.params = params;
        this.v = new BigInteger(1, vb);
        this.g = new BigInteger(1, params.g);
        this.N = new BigInteger(1, params.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("g: " + Util.tob64(params.g)));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("v: " + Util.tob64(vb)));
        }
        this.serverHash = Util.newDigest();
        this.clientHash = Util.newDigest();
        byte[] hn = Util.newDigest().digest(params.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(N): " + Util.tob64(hn)));
        }
        byte[] hg = Util.newDigest().digest(params.g);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(g): " + Util.tob64(hg)));
        }
        byte[] hxg = Util.xor(hn, hg, 20);
        if (log.isTraceEnabled()) {
            log.trace((Object)("H(N) xor H(g): " + Util.tob64(hxg)));
        }
        this.clientHash.update(hxg);
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace((Object)("H[H(N) xor H(g)]: " + Util.tob64(tmp.digest())));
        }
        this.clientHash.update(Util.newDigest().digest(username.getBytes()));
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U)]: " + Util.tob64(tmp.digest())));
        }
        this.clientHash.update(params.s);
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s]: " + Util.tob64(tmp.digest())));
        }
        this.K = null;
    }

    public SRPParameters getParameters() {
        return this.params;
    }

    public byte[] exponential() {
        if (this.B == null) {
            BigInteger one = BigInteger.valueOf(1L);
            do {
                this.b = new BigInteger(B_LEN, Util.getPRNG());
            } while (this.b.compareTo(one) <= 0);
            this.B = this.v.add(this.g.modPow(this.b, this.N));
            if (this.B.compareTo(this.N) >= 0) {
                this.B = this.B.subtract(this.N);
            }
        }
        return Util.trim(this.B.toByteArray());
    }

    public void buildSessionKey(byte[] ab) throws NoSuchAlgorithmException {
        MessageDigest tmp;
        if (log.isTraceEnabled()) {
            log.trace((Object)("A: " + Util.tob64(ab)));
        }
        byte[] nb = Util.trim(this.B.toByteArray());
        this.clientHash.update(ab);
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A]: " + Util.tob64(tmp.digest())));
        }
        this.clientHash.update(nb);
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A | B]: " + Util.tob64(tmp.digest())));
        }
        this.serverHash.update(ab);
        byte[] hB = Util.newDigest().digest(nb);
        byte[] ub = new byte[]{hB[0], hB[1], hB[2], hB[3]};
        BigInteger A = new BigInteger(1, ab);
        if (log.isTraceEnabled()) {
            log.trace((Object)("A: " + Util.tob64(A.toByteArray())));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("B: " + Util.tob64(this.B.toByteArray())));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("v: " + Util.tob64(this.v.toByteArray())));
        }
        BigInteger u = new BigInteger(1, ub);
        if (log.isTraceEnabled()) {
            log.trace((Object)("u: " + Util.tob64(u.toByteArray())));
        }
        BigInteger A_v2u = A.multiply(this.v.modPow(u, this.N)).mod(this.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("A * v^u: " + Util.tob64(A_v2u.toByteArray())));
        }
        BigInteger S = A_v2u.modPow(this.b, this.N);
        if (log.isTraceEnabled()) {
            log.trace((Object)("S: " + Util.tob64(S.toByteArray())));
        }
        MessageDigest sessionDigest = MessageDigest.getInstance(this.params.hashAlgorithm);
        this.K = sessionDigest.digest(S.toByteArray());
        if (log.isTraceEnabled()) {
            log.trace((Object)("K: " + Util.tob64(this.K)));
        }
        this.clientHash.update(this.K);
        if (log.isTraceEnabled()) {
            MessageDigest tmp2 = Util.copy(this.clientHash);
            log.trace((Object)("H[H(N) xor H(g) | H(U) | s | A | B | K]: " + Util.tob64(tmp2.digest())));
        }
    }

    public byte[] getSessionKey() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SRPPermission p = new SRPPermission("getSessionKey");
            sm.checkPermission(p);
        }
        return this.K;
    }

    public byte[] getServerResponse() {
        if (this.M2 == null) {
            this.M2 = this.serverHash.digest();
        }
        return this.M2;
    }

    public byte[] getClientResponse() {
        return this.M1;
    }

    public boolean verify(byte[] clientM1) {
        boolean valid = false;
        this.M1 = this.clientHash.digest();
        if (log.isTraceEnabled()) {
            log.trace((Object)("verify M1: " + Util.tob64(this.M1)));
            log.trace((Object)("verify clientM1: " + Util.tob64(clientM1)));
        }
        if (Arrays.equals(clientM1, this.M1)) {
            this.serverHash.update(this.M1);
            this.serverHash.update(this.K);
            if (log.isTraceEnabled()) {
                MessageDigest tmp = Util.copy(this.serverHash);
                log.trace((Object)("H(A | M1 | K)" + Util.tob64(tmp.digest())));
            }
            valid = true;
        }
        return valid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

