/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class JDOHelper {
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public static PersistenceManager getPersistenceManager(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoGetPersistenceManager() : null;
    }

    public static void makeDirty(Object pc, String fieldName) {
        if (pc instanceof PersistenceCapable) {
            ((PersistenceCapable)pc).jdoMakeDirty(fieldName);
        }
    }

    public static Object getObjectId(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoGetObjectId() : null;
    }

    public static Object getTransactionalObjectId(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoGetTransactionalObjectId() : null;
    }

    public static Object getVersion(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoGetVersion() : null;
    }

    public static boolean isDirty(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsDirty() : false;
    }

    public static boolean isTransactional(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsTransactional() : false;
    }

    public static boolean isPersistent(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsPersistent() : false;
    }

    public static boolean isNew(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsNew() : false;
    }

    public static boolean isDeleted(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsDeleted() : false;
    }

    public static boolean isDetached(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsDetached() : false;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map props) {
        ClassLoader cl = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(props, cl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PersistenceManagerFactory getPersistenceManagerFactory(Map props, ClassLoader cl) {
        String pmfClassName = (String)props.get("javax.jdo.PersistenceManagerFactoryClass");
        if (pmfClassName == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoClassNameProperty"));
        }
        Method propsMethod = null;
        JDOFatalInternalException propsGetMethodException = null;
        Method mapMethod = null;
        JDOFatalInternalException mapGetMethodException = null;
        Method pmfMethod = null;
        try {
            Class<?> pmfClass = cl.loadClass(pmfClassName);
            try {
                propsMethod = pmfClass.getMethod("getPersistenceManagerFactory", class$java$util$Properties == null ? (class$java$util$Properties = JDOHelper.class$("java.util.Properties")) : class$java$util$Properties);
            }
            catch (NoSuchMethodException nsme) {
                propsGetMethodException = new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod"), nsme);
            }
            try {
                mapMethod = pmfClass.getMethod("getPersistenceManagerFactory", class$java$util$Map == null ? (class$java$util$Map = JDOHelper.class$("java.util.Map")) : class$java$util$Map);
            }
            catch (NoSuchMethodException nsme) {
                mapGetMethodException = new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod"), nsme);
            }
            if (!(props instanceof Properties)) {
                if (mapMethod == null) throw mapGetMethodException;
                pmfMethod = mapMethod;
                return (PersistenceManagerFactory)pmfMethod.invoke(null, props);
            } else if (mapMethod != null) {
                pmfMethod = mapMethod;
                return (PersistenceManagerFactory)pmfMethod.invoke(null, props);
            } else {
                if (propsMethod == null) throw mapGetMethodException;
                pmfMethod = propsMethod;
            }
            return (PersistenceManagerFactory)pmfMethod.invoke(null, props);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFClassNotFound", pmfClassName), cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIllegalAccess", pmfClassName), iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod"), nsme);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (!(nested instanceof JDOException)) throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), ite);
            throw (JDOException)nested;
        }
        catch (NullPointerException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPointerException", pmfClassName), e);
        }
        catch (ClassCastException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFClassCastException", pmfClassName), e);
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), e);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String propsResource) {
        return JDOHelper.getPersistenceManagerFactory(propsResource, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String propsResource, ClassLoader loader) {
        return JDOHelper.getPersistenceManagerFactory(propsResource, loader, loader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PersistenceManagerFactory getPersistenceManagerFactory(String propsResource, ClassLoader propsLoader, ClassLoader pmfLoader) {
        if (propsResource == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullResource"));
        }
        if (propsLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPropsLoader"));
        }
        if (pmfLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPMFLoader"));
        }
        Properties props = new Properties();
        InputStream in = null;
        try {
            try {
                in = propsLoader.getResourceAsStream(propsResource);
                if (in == null) {
                    throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoResource", propsResource, propsLoader));
                }
                props.load(in);
            }
            catch (IOException ioe) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", propsResource), ioe);
            }
            Object var7_5 = null;
            if (in == null) return JDOHelper.getPersistenceManagerFactory(props, pmfLoader);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        in.close();
        return JDOHelper.getPersistenceManagerFactory(props, pmfLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File propsFile) {
        return JDOHelper.getPersistenceManagerFactory(propsFile, JDOHelper.getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PersistenceManagerFactory getPersistenceManagerFactory(File propsFile, ClassLoader loader) {
        if (propsFile == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullFile"));
        }
        if (loader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(propsFile);
                props.load(in);
            }
            catch (FileNotFoundException fnfe) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoFile", propsFile, loader), fnfe);
            }
            catch (IOException ioe) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionFile", propsFile), ioe);
            }
            Object var6_4 = null;
            if (in == null) return JDOHelper.getPersistenceManagerFactory(props, loader);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        ((InputStream)in).close();
        return JDOHelper.getPersistenceManagerFactory(props, loader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String jndiLocation, Context context) {
        return JDOHelper.getPersistenceManagerFactory(jndiLocation, context, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String jndiLocation, Context context, ClassLoader loader) {
        if (jndiLocation == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullJndiLoc"));
        }
        if (loader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        try {
            if (context == null) {
                context = new InitialContext();
            }
            Object o = context.lookup(jndiLocation);
            return (PersistenceManagerFactory)PortableRemoteObject.narrow((Object)o, (Class)(class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = JDOHelper.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory));
        }
        catch (NamingException ne) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNamingException", jndiLocation, loader), ne);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream stream) {
        return JDOHelper.getPersistenceManagerFactory(stream, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream stream, ClassLoader loader) {
        if (stream == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullStream"));
        }
        if (loader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionStream"), ioe);
        }
        return JDOHelper.getPersistenceManagerFactory(props, loader);
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

