/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jdo.JDOUserException;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.JDOImplHelper;

public class ObjectIdentity
extends SingleFieldIdentity {
    private static JDOImplHelper helper = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JDOImplHelper.getInstance();
        }
    });
    public static String STRING_DELIMITER = ":";

    public ObjectIdentity(Class pcClass, Object param) {
        super(pcClass);
        this.assertKeyNotNull(param);
        String paramString = null;
        String keyString = null;
        String className = null;
        if (param instanceof String) {
            paramString = (String)param;
            if (paramString.length() < 3) {
                throw new JDOUserException(msg.msg("EXC_ObjectIdentityStringConstructionTooShort") + msg.msg("EXC_ObjectIdentityStringConstructionUsage", paramString));
            }
            int indexOfDelimiter = paramString.indexOf(STRING_DELIMITER);
            if (indexOfDelimiter < 0) {
                throw new JDOUserException(msg.msg("EXC_ObjectIdentityStringConstructionNoDelimiter") + msg.msg("EXC_ObjectIdentityStringConstructionUsage", paramString));
            }
            keyString = paramString.substring(indexOfDelimiter + 1);
            className = paramString.substring(0, indexOfDelimiter);
            this.keyAsObject = helper.construct(className, keyString);
        } else {
            this.keyAsObject = param;
        }
        this.hashCode = this.hashClassName() ^ this.keyAsObject.hashCode();
    }

    public ObjectIdentity() {
    }

    public Object getKey() {
        return this.keyAsObject;
    }

    public String toString() {
        return this.keyAsObject.getClass().getName() + STRING_DELIMITER + this.keyAsObject.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ObjectIdentity other = (ObjectIdentity)obj;
        return this.keyAsObject.equals(other.keyAsObject);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.keyAsObject);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.keyAsObject = in.readObject();
    }
}

