/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.IntOrder;
import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.ParserInternals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BestParser<T>
extends Parser<T> {
    private final Parser<? extends T>[] parsers;
    private final IntOrder order;

    BestParser(Parser<? extends T>[] parsers, IntOrder order) {
        this.parsers = parsers;
        this.order = order;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        Object result = ctxt.result;
        int step = ctxt.step;
        int at = ctxt.at;
        for (int i = 0; i < this.parsers.length; ++i) {
            Parser<T> parser = this.parsers[i];
            if (parser.run(ctxt)) {
                ParserInternals.runForBestFit(this.order, this.parsers, i + 1, ctxt, result, step, at);
                return true;
            }
            ctxt.set(step, at, result);
        }
        return false;
    }

    public String toString() {
        return this.order.toString();
    }
}

