/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.codehaus.jparsec.InternalFunctors;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.Token;
import org.codehaus.jparsec._;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.functors.Unary;
import org.codehaus.jparsec.pattern.CharPredicate;
import org.codehaus.jparsec.pattern.Pattern;
import org.codehaus.jparsec.pattern.Patterns;
import org.codehaus.jparsec.util.Lists;
import org.codehaus.jparsec.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Indentation {
    static final CharPredicate INLINE_WHITESPACE = new CharPredicate(){

        public boolean isChar(char c) {
            return c != '\n' && Character.isWhitespace(c);
        }

        public String toString() {
            return "whitespace";
        }
    };
    static final Pattern LINE_CONTINUATION = Patterns.sequence(Patterns.isChar('\\'), Patterns.many(INLINE_WHITESPACE), Patterns.isChar('\n'));
    static final Pattern INLINE_WHITESPACES = Patterns.many1(INLINE_WHITESPACE);
    public static final Parser<_> WHITESPACES = Scanners.pattern(INLINE_WHITESPACES.or(LINE_CONTINUATION).many1(), "whitespaces");
    private final Object indent;
    private final Object outdent;

    public Indentation(Object indent, Object outdent) {
        this.indent = indent;
        this.outdent = outdent;
    }

    public Indentation() {
        this((Object)Punctuation.INDENT, (Object)Punctuation.OUTDENT);
    }

    public Parser<Token> indent() {
        return Indentation.token(this.indent);
    }

    public Parser<Token> outdent() {
        return Indentation.token(this.outdent);
    }

    public Parser<List<Token>> lexer(Parser<?> tokenizer, Parser<?> delim) {
        Parser<Punctuation> lf = Scanners.isChar('\n').retn(Punctuation.LF);
        return Parsers.plus(tokenizer, lf).lexer(delim).map(new Unary<List<Token>>(){

            @Override
            public List<Token> map(List<Token> tokens) {
                return Indentation.this.analyzeIndentations(tokens, (Object)Punctuation.LF);
            }

            public String toString() {
                return "lexer";
            }
        });
    }

    private static Parser<Token> token(Object value) {
        return Parsers.token(InternalFunctors.tokenWithSameValue(value));
    }

    List<Token> analyzeIndentations(List<Token> tokens, Object lf) {
        if (tokens.isEmpty()) {
            return tokens;
        }
        int size = tokens.size();
        ArrayList<Token> result = Lists.arrayList(size + size / 16);
        Stack<Integer> indentations = new Stack<Integer>();
        boolean freshLine = true;
        int lfIndex = 0;
        for (Token token : tokens) {
            if (freshLine) {
                int indentation = token.index() - lfIndex;
                if (Objects.equals(token.value(), lf)) {
                    indentation = 0;
                }
                this.newLine(token, indentations, indentation, result);
            }
            if (Objects.equals(token.value(), lf)) {
                freshLine = true;
                lfIndex = token.index() + token.length();
                continue;
            }
            freshLine = false;
            result.add(token);
        }
        Token lastToken = tokens.get(tokens.size() - 1);
        int endIndex = lastToken.index() + lastToken.length();
        Token outdentToken = Indentation.pseudoToken(endIndex, this.outdent);
        for (int i = 0; i < indentations.size() - 1; ++i) {
            result.add(outdentToken);
        }
        return result;
    }

    private void newLine(Token token, Stack<Integer> indentations, int indentation, List<Token> result) {
        while (true) {
            if (indentations.isEmpty()) {
                indentations.add(indentation);
                return;
            }
            int previousIndentation = indentations.peek();
            if (previousIndentation < indentation) {
                indentations.push(indentation);
                result.add(Indentation.pseudoToken(token.index(), this.indent));
                return;
            }
            if (previousIndentation <= indentation) break;
            indentations.pop();
            if (indentations.isEmpty()) {
                return;
            }
            result.add(Indentation.pseudoToken(token.index(), this.outdent));
        }
    }

    private static Token pseudoToken(int index, Object value) {
        return new Token(index, 0, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Private
    static enum Punctuation {
        INDENT,
        OUTDENT,
        LF;

    }
}

