/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.Token;
import org.codehaus.jparsec.TokenMap;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Map2;
import org.codehaus.jparsec.functors.Map3;
import org.codehaus.jparsec.functors.Map4;
import org.codehaus.jparsec.functors.Map5;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InternalFunctors {
    private static final Map2 FIRST_OF_TWO = new Map2(){

        public Object map(Object first, Object b) {
            return first;
        }

        public String toString() {
            return "followedBy";
        }
    };
    private static final Map2 LAST_OF_TWO = new Map2(){

        public Object map(Object a, Object last) {
            return last;
        }

        public String toString() {
            return "sequence";
        }
    };
    private static final Map3 LAST_OF_THREE = new Map3(){

        public Object map(Object a, Object b, Object last) {
            return last;
        }

        public String toString() {
            return "sequence";
        }
    };
    private static final Map4 LAST_OF_FOUR = new Map4(){

        public Object map(Object a, Object b, Object c, Object last) {
            return last;
        }

        public String toString() {
            return "sequence";
        }
    };
    private static final Map5 LAST_OF_FIVE = new Map5(){

        public Object map(Object a, Object b, Object c, Object d, Object last) {
            return last;
        }

        public String toString() {
            return "sequence";
        }
    };

    InternalFunctors() {
    }

    static <T> TokenMap<T> isTokenType(final Class<T> targetType, final String name) {
        return new TokenMap<T>(){

            @Override
            public T map(Token token) {
                if (targetType.isInstance(token.value())) {
                    return targetType.cast(token.value());
                }
                return null;
            }

            public String toString() {
                return name;
            }
        };
    }

    static TokenMap<Token> tokenWithSameValue(final Object value) {
        return new TokenMap<Token>(){

            @Override
            public Token map(Token token) {
                return value == token.value() ? token : null;
            }

            public String toString() {
                return String.valueOf(value);
            }
        };
    }

    static <T, B> Map2<T, B, T> firstOfTwo() {
        return FIRST_OF_TWO;
    }

    static <A, T> Map2<A, T, T> lastOfTwo() {
        return LAST_OF_TWO;
    }

    static <A, B, T> Map3<A, B, T, T> lastOfThree() {
        return LAST_OF_THREE;
    }

    static <A, B, C, T> Map4<A, B, C, T, T> lastOfFour() {
        return LAST_OF_FOUR;
    }

    static <A, B, C, D, T> Map5<A, B, C, D, T, T> lastOfFive() {
        return LAST_OF_FIVE;
    }

    public static <F, T> Map<F, T> fallback(final Map<F, T> map, final Map<? super F, ? extends T> defaultMap) {
        return new Map<F, T>(){

            @Override
            public T map(F v) {
                Object result = map.map(v);
                return result == null ? defaultMap.map(v) : result;
            }

            public String toString() {
                return "fallback";
            }
        };
    }
}

