/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.codehaus.jparsec.Lexicon;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Tokens;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Keywords {
    private static final StringCase CASE_SENSITIVE = new CaseSensitive();
    private static final StringCase CASE_INSENSITIVE = new CaseInsensitive();

    Keywords() {
    }

    private static StringCase getStringCase(boolean caseSensitive) {
        return caseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
    }

    @Private
    static String[] unique(Comparator<String> c, String ... names) {
        TreeSet<String> set = new TreeSet<String>(c);
        set.addAll(Arrays.asList(names));
        return set.toArray(new String[set.size()]);
    }

    static <T> Lexicon lexicon(Parser<String> wordScanner, String[] keywordNames, boolean caseSensitive, final Map<String, ?> defaultMap) {
        StringCase scase = Keywords.getStringCase(caseSensitive);
        HashMap<String, Tokens.Fragment> map = new HashMap<String, Tokens.Fragment>();
        for (String n : Keywords.unique(scase.comparator(), keywordNames)) {
            Tokens.Fragment value = Tokens.reserved(n);
            map.put(scase.toKey(n), value);
        }
        final Map<String, Object> fmap = scase.toMap(map);
        Map<String, Object> tokenizerMap = new Map<String, Object>(){

            @Override
            public Object map(String text) {
                Object val = fmap.map(text);
                if (val != null) {
                    return val;
                }
                return defaultMap.map(text);
            }
        };
        return new Lexicon(fmap, wordScanner.map(tokenizerMap));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitive
    implements StringCase {
        private static Comparator<String> COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                if (a == b) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                return a.compareToIgnoreCase(b);
            }
        };

        private CaseInsensitive() {
        }

        @Override
        public Comparator<String> comparator() {
            return COMPARATOR;
        }

        @Override
        public String toKey(String k) {
            return k.toLowerCase();
        }

        @Override
        public <T> Map<String, T> toMap(final java.util.Map<String, T> m) {
            return new Map<String, T>(){

                @Override
                public T map(String key) {
                    return m.get(key.toLowerCase());
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseSensitive
    implements StringCase {
        private static Comparator<String> COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                if (a == b) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                return a.compareTo(b);
            }
        };

        private CaseSensitive() {
        }

        @Override
        public Comparator<String> comparator() {
            return COMPARATOR;
        }

        @Override
        public String toKey(String k) {
            return k;
        }

        @Override
        public <T> Map<String, T> toMap(java.util.Map<String, T> m) {
            return Maps.map(m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface StringCase {
        public Comparator<String> comparator();

        public String toKey(String var1);

        public <T> Map<String, T> toMap(java.util.Map<String, T> var1);
    }
}

