/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.InternalFunctors;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Token;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.util.Checks;
import org.codehaus.jparsec.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Lexicon {
    final Map<String, Object> words;
    final Parser<?> tokenizer;

    Lexicon(Map<String, Object> words, Parser<?> tokenizer) {
        this.words = words;
        this.tokenizer = tokenizer;
    }

    public Parser<?> tokenizer() {
        return this.tokenizer;
    }

    public Parser<?> phrase(String ... tokenNames) {
        Parser[] wordParsers = new Parser[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
            wordParsers[i] = this.token(tokenNames[i]);
        }
        return Parsers.sequence(wordParsers).atomic().label(Strings.join(" ", tokenNames));
    }

    public Parser<Token> token(String ... tokenNames) {
        if (tokenNames.length == 0) {
            return Parsers.never();
        }
        Parser[] ps = new Parser[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
            ps[i] = Parsers.token(InternalFunctors.tokenWithSameValue(this.word(tokenNames[i])));
        }
        return Parsers.plus(ps);
    }

    public Parser<Token> token(String tokenName) {
        return Parsers.token(InternalFunctors.tokenWithSameValue(this.word(tokenName)));
    }

    @Private
    Object word(String name) {
        Object p = this.words.map(name);
        Checks.checkArgument(p != null, "token %s unavailable", name);
        return p;
    }

    Lexicon union(Lexicon that) {
        return new Lexicon(InternalFunctors.fallback(this.words, that.words), Parsers.plus(this.tokenizer, that.tokenizer));
    }
}

