/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jparsec.ListFactory;
import org.codehaus.jparsec.util.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListFactories {
    private static final ListFactory ARRAY_LIST_FACTORY = new ListFactory<Object>(){

        @Override
        public List<Object> newList() {
            return Lists.arrayList();
        }
    };

    ListFactories() {
    }

    public static <T> ListFactory<T> arrayListFactory() {
        return ARRAY_LIST_FACTORY;
    }

    public static <T> ListFactory<T> arrayListFactoryWithFirstElement(final T first) {
        return new ListFactory<T>(){

            @Override
            public List<T> newList() {
                ArrayList list = Lists.arrayList();
                list.add(first);
                return list;
            }
        };
    }
}

