/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.List;
import org.codehaus.jparsec.ListFactories;
import org.codehaus.jparsec.ListFactory;
import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.ParserInternals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ManyMinListParser<T>
extends Parser<List<T>> {
    private final Parser<? extends T> parser;
    private final int min;
    private final ListFactory<T> listFactory;

    ManyMinListParser(Parser<? extends T> parser, int min) {
        this(parser, min, ListFactories.arrayListFactory());
    }

    ManyMinListParser(Parser<? extends T> parser, int min, ListFactory<T> listFactory) {
        this.parser = parser;
        this.min = min;
        this.listFactory = listFactory;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        List<T> result = this.listFactory.newList();
        if (!ParserInternals.repeat(this.parser, this.min, result, ctxt)) {
            return false;
        }
        if (ParserInternals.many(this.parser, result, ctxt)) {
            ctxt.result = result;
            return true;
        }
        return false;
    }

    public String toString() {
        return "many";
    }
}

