/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.ParserInternals;
import org.codehaus.jparsec._;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NestableBlockCommentScanner
extends Parser<_> {
    private final Parser<?> openQuote;
    private final Parser<?> closeQuote;
    private final Parser<?> commented;

    NestableBlockCommentScanner(Parser<?> openQuote, Parser<?> closeQuote, Parser<?> commented) {
        this.openQuote = openQuote;
        this.closeQuote = closeQuote;
        this.commented = commented;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        if (!this.openQuote.run(ctxt)) {
            return false;
        }
        int level = 1;
        while (level > 0) {
            int step = ctxt.step;
            int at = ctxt.at;
            if (this.closeQuote.run(ctxt)) {
                if (at == ctxt.at) {
                    throw new IllegalStateException("closing comment scanner not consuming input.");
                }
                --level;
                continue;
            }
            if (!ParserInternals.stillThere(ctxt, at, step)) {
                return false;
            }
            if (this.openQuote.run(ctxt)) {
                if (at == ctxt.at) {
                    throw new IllegalStateException("opening comment scanner not consuming input.");
                }
                ++level;
                continue;
            }
            if (!ParserInternals.stillThere(ctxt, at, step)) {
                return false;
            }
            if (this.commented.run(ctxt)) {
                if (at != ctxt.at) continue;
                throw new IllegalStateException("commented scanner not consuming input.");
            }
            return false;
        }
        ctxt.result = null;
        return true;
    }

    public String toString() {
        return "nestable block comment";
    }
}

