/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

final class NumberLiteralsTranslator {
    NumberLiteralsTranslator() {
    }

    private static int toDecDigit(char c) {
        return c - 48;
    }

    private static int toOctDigit(char c) {
        return c - 48;
    }

    private static int toHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'h') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static Long tokenizeDecimalAsLong(String text) {
        long n = 0L;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            n = n * 10L + (long)NumberLiteralsTranslator.toDecDigit(text.charAt(i));
        }
        return n;
    }

    static Long tokenizeOctalAsLong(String text) {
        long n = 0L;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            n = n * 8L + (long)NumberLiteralsTranslator.toOctDigit(text.charAt(i));
        }
        return n;
    }

    static Long tokenizeHexAsLong(String text) {
        int len = text.length();
        if (len < 3) {
            throw new IllegalStateException("illegal hex number");
        }
        long n = 0L;
        for (int i = 2; i < len; ++i) {
            n = n * 16L + (long)NumberLiteralsTranslator.toHexDigit(text.charAt(i));
        }
        return n;
    }
}

