/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.Collections;
import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Map2;
import org.codehaus.jparsec.util.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorTable<T> {
    private final List<Operator> ops = Lists.arrayList();

    public OperatorTable<T> prefix(Parser<? extends Map<? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.PREFIX));
        return this;
    }

    public OperatorTable<T> postfix(Parser<? extends Map<? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.POSTFIX));
        return this;
    }

    public OperatorTable<T> infixl(Parser<? extends Map2<? super T, ? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.LASSOC));
        return this;
    }

    public OperatorTable<T> infixr(Parser<? extends Map2<? super T, ? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.RASSOC));
        return this;
    }

    public OperatorTable<T> infixn(Parser<? extends Map2<? super T, ? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.NASSOC));
        return this;
    }

    public Parser<T> build(Parser<? extends T> operand) {
        return OperatorTable.buildExpressionParser(operand, this.operators());
    }

    @Private
    Operator[] operators() {
        Collections.sort(this.ops);
        return this.ops.toArray(new Operator[this.ops.size()]);
    }

    static <T> Parser<T> buildExpressionParser(Parser<? extends T> term, Operator ... ops) {
        if (ops.length == 0) {
            return term.cast();
        }
        int begin = 0;
        int precedence = ops[0].precedence;
        Associativity associativity = ops[0].associativity;
        int end = 0;
        Parser ret = term.cast();
        for (int i = 1; i < ops.length; ++i) {
            Operator op = ops[i];
            end = i;
            if (op.precedence == precedence && op.associativity == associativity) continue;
            end = i;
            Parser<?> p = OperatorTable.slice(ops, begin, end);
            ret = OperatorTable.build(p, associativity, ret);
            begin = i;
            precedence = ops[i].precedence;
            associativity = ops[i].associativity;
        }
        if (end != ops.length) {
            end = ops.length;
            associativity = ops[begin].associativity;
            Parser<?> p = OperatorTable.slice(ops, begin, end);
            ret = OperatorTable.build(p, associativity, ret);
        }
        return ret.cast();
    }

    private static Parser<?> slice(Operator[] ops, int begin, int end) {
        Parser[] ps = new Parser[end - begin];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = ops[i + begin].op;
        }
        return Parsers.or(ps);
    }

    private static <T> Parser<T> build(Parser op, Associativity associativity, Parser<T> operand) {
        switch (associativity) {
            case PREFIX: {
                return operand.prefix(op);
            }
            case POSTFIX: {
                return operand.postfix(op);
            }
            case LASSOC: {
                return operand.infixl(op);
            }
            case RASSOC: {
                return operand.infixr(op);
            }
            case NASSOC: {
                return operand.infixn(op);
            }
        }
        throw new AssertionError();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Operator
    implements Comparable<Operator> {
        final Parser<?> op;
        final int precedence;
        final Associativity associativity;

        Operator(Parser<?> op, int precedence, Associativity associativity) {
            this.op = op;
            this.precedence = precedence;
            this.associativity = associativity;
        }

        @Override
        public int compareTo(Operator that) {
            if (this.precedence > that.precedence) {
                return -1;
            }
            if (this.precedence < that.precedence) {
                return 1;
            }
            return this.associativity.compareTo(that.associativity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Associativity {
        PREFIX,
        POSTFIX,
        LASSOC,
        NASSOC,
        RASSOC;

    }
}

