/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.codehaus.jparsec.Lexicon;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.Tokens;
import org.codehaus.jparsec._;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.functors.Maps;
import org.codehaus.jparsec.util.Lists;

final class Operators {
    private static final Comparator<String> LONGER_STRING_FIRST = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return b.length() - a.length();
        }
    };

    Operators() {
    }

    static Lexicon lexicon(String ... operatorNames) {
        HashMap<String, Tokens.Fragment> operators = new HashMap<String, Tokens.Fragment>();
        String[] ops = Operators.sort(operatorNames);
        Parser[] lexers = new Parser[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            String s = ops[i];
            Parser<_> scanner = s.length() == 1 ? Scanners.isChar(s.charAt(0)) : Scanners.string(s);
            Tokens.Fragment value = Tokens.reserved(s);
            operators.put(s, value);
            lexers[i] = scanner.retn(value);
        }
        return new Lexicon(Maps.map(operators), Parsers.plus(lexers));
    }

    @Private
    static String[] sort(String ... names) {
        String[] copy = (String[])names.clone();
        Arrays.sort(copy, LONGER_STRING_FIRST);
        Suites suites = new Suites();
        for (String name : copy) {
            suites.add(name);
        }
        return suites.toArray();
    }

    private static final class Suites {
        private final ArrayList<Suite> list = Lists.arrayList();

        private Suites() {
        }

        void add(String v) {
            for (Suite suite : this.list) {
                if (!suite.add(v)) continue;
                return;
            }
            this.list.add(new Suite(v));
        }

        String[] toArray() {
            ArrayList<String> result = Lists.arrayList();
            for (int i = this.list.size() - 1; i >= 0; --i) {
                Suite suite = this.list.get(i);
                for (String name : suite.list) {
                    result.add(name);
                }
            }
            return result.toArray(new String[result.size()]);
        }
    }

    private static final class Suite {
        final ArrayList<String> list = Lists.arrayList();

        Suite(String s) {
            if (s.length() > 0) {
                this.list.add(s);
            }
        }

        boolean add(String v) {
            if (v.length() == 0) {
                return true;
            }
            for (int i = this.list.size() - 1; i >= 0; --i) {
                String s = this.list.get(i);
                if (!s.startsWith(v)) continue;
                if (s.length() == v.length()) {
                    return true;
                }
                this.list.add(i + 1, v);
                return true;
            }
            return false;
        }
    }
}

