/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jparsec.EmptyParseError;
import org.codehaus.jparsec.SourceLocator;
import org.codehaus.jparsec.Token;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.error.ParseErrorDetails;
import org.codehaus.jparsec.util.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ParseContext {
    static final String EOF = "EOF";
    final String module;
    final CharSequence source;
    final SourceLocator locator;
    int at;
    int step;
    Object result;
    private ErrorType currentErrorType = ErrorType.NONE;
    private int currentErrorAt;
    private int currentErrorIndex = 0;
    private final ArrayList<Object> errors = Lists.arrayList();
    private String encountered = null;
    private boolean errorSuppressed = false;

    final boolean suppressError(boolean value) {
        boolean oldValue = this.errorSuppressed;
        this.errorSuppressed = value;
        return oldValue;
    }

    final int errorIndex() {
        return this.currentErrorIndex;
    }

    final ErrorType errorType() {
        return this.currentErrorType;
    }

    final List<Object> errors() {
        return this.errors;
    }

    final ParseErrorDetails renderError() {
        int errorIndex = this.toIndex(this.currentErrorAt);
        String encounteredName = this.getEncountered();
        final ArrayList errorStrings = Lists.arrayList(this.errors.size());
        for (Object error : this.errors) {
            errorStrings.add(String.valueOf(error));
        }
        switch (this.currentErrorType) {
            case UNEXPECTED: {
                return new EmptyParseError(errorIndex, encounteredName){

                    public String getUnexpected() {
                        return (String)errorStrings.get(0);
                    }
                };
            }
            case FAILURE: {
                return new EmptyParseError(errorIndex, encounteredName){

                    public String getFailureMessage() {
                        return (String)errorStrings.get(0);
                    }
                };
            }
            case EXPECTED: 
            case EXPECT: {
                return new EmptyParseError(errorIndex, encounteredName){

                    @Override
                    public List<String> getExpected() {
                        return errorStrings;
                    }
                };
            }
        }
        return new EmptyParseError(errorIndex, encounteredName);
    }

    final String getEncountered() {
        if (this.encountered != null) {
            return this.encountered;
        }
        return this.getInputName(this.currentErrorAt);
    }

    final void setEncountered(String encountered) {
        this.encountered = encountered;
    }

    abstract String getInputName(int var1);

    abstract boolean isEof();

    final int getIndex() {
        return this.toIndex(this.at);
    }

    abstract Token getToken();

    abstract char peekChar();

    abstract int toIndex(int var1);

    @Private
    final void raise(ErrorType type, Object subject) {
        if (this.errorSuppressed) {
            return;
        }
        if (this.at < this.currentErrorAt) {
            return;
        }
        if (this.at > this.currentErrorAt) {
            this.setErrorState(this.at, this.getIndex(), type);
            this.errors.add(subject);
            return;
        }
        if (type.ordinal() < this.currentErrorType.ordinal()) {
            return;
        }
        if (type.ordinal() > this.currentErrorType.ordinal()) {
            this.setErrorState(this.at, this.getIndex(), type);
            this.errors.add(subject);
            return;
        }
        if (type.mergeable) {
            this.errors.add(subject);
        }
    }

    final void trap() {
        this.raise(ErrorType.TRAP, null);
    }

    final void fail(String message) {
        this.raise(ErrorType.FAILURE, message);
    }

    final void expected(Object what) {
        this.raise(ErrorType.EXPECTED, what);
    }

    final void unexpected(String what) {
        this.raise(ErrorType.UNEXPECTED, what);
    }

    final void set(int step, int at, Object ret) {
        this.step = step;
        this.at = at;
        this.result = ret;
    }

    final void setErrorState(int errorAt, int errorIndex, ErrorType errorType, List<Object> errors) {
        this.setErrorState(errorAt, errorIndex, errorType);
        this.errors.addAll(errors);
    }

    private void setErrorState(int errorAt, int errorIndex, ErrorType errorType) {
        this.currentErrorIndex = errorIndex;
        this.currentErrorAt = errorAt;
        this.currentErrorType = errorType;
        this.encountered = null;
        this.errors.clear();
    }

    final void setAt(int step, int at) {
        this.step = step;
        this.at = at;
    }

    final void next() {
        ++this.at;
        ++this.step;
    }

    final void next(int n) {
        this.at += n;
        if (n > 0) {
            ++this.step;
        }
    }

    ParseContext(CharSequence source, int at, String module, SourceLocator locator) {
        this(source, null, at, module, locator);
    }

    ParseContext(CharSequence source, Object ret, int at, String module, SourceLocator locator) {
        this.source = source;
        this.result = ret;
        this.step = 0;
        this.at = at;
        this.module = module;
        this.locator = locator;
        this.currentErrorAt = at;
    }

    abstract CharSequence characters();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ErrorType {
        NONE(false),
        TRAP(false),
        UNEXPECTED(false),
        EXPECTED(true),
        FAILURE(false),
        EXPECT(true);

        final boolean mergeable;

        private ErrorType(boolean mergeable) {
            this.mergeable = mergeable;
        }
    }
}

