/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jparsec.AtomicParser;
import org.codehaus.jparsec.BindNextParser;
import org.codehaus.jparsec.DefaultSourceLocator;
import org.codehaus.jparsec.DelimitedListParser;
import org.codehaus.jparsec.DelimitedParser;
import org.codehaus.jparsec.EmptyListParser;
import org.codehaus.jparsec.IfElseParser;
import org.codehaus.jparsec.InternalFunctors;
import org.codehaus.jparsec.LazyParser;
import org.codehaus.jparsec.ListFactories;
import org.codehaus.jparsec.ManyListParser;
import org.codehaus.jparsec.ManyMinListParser;
import org.codehaus.jparsec.ManyMinParser;
import org.codehaus.jparsec.ManyParser;
import org.codehaus.jparsec.MapParser;
import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.PeekParser;
import org.codehaus.jparsec.RepeatListParser;
import org.codehaus.jparsec.RepeatParser;
import org.codehaus.jparsec.ReturnSourceParser;
import org.codehaus.jparsec.SomeMaxListParser;
import org.codehaus.jparsec.SomeMaxParser;
import org.codehaus.jparsec.SomeMinMaxListParser;
import org.codehaus.jparsec.SomeMinMaxParser;
import org.codehaus.jparsec.SourceLocator;
import org.codehaus.jparsec.StepParser;
import org.codehaus.jparsec.ToTokenParser;
import org.codehaus.jparsec.Token;
import org.codehaus.jparsec._;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.error.ParserException;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Map2;
import org.codehaus.jparsec.functors.Maps;
import org.codehaus.jparsec.util.Checks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parser<T> {
    Parser() {
    }

    public static <T> Reference<T> newReference() {
        return new Reference();
    }

    public final <R> Parser<R> retn(R value) {
        return this.next(Parsers.constant(value));
    }

    public final <R> Parser<R> next(Parser<R> parser) {
        return Parsers.sequence(this, parser);
    }

    public final <To> Parser<To> next(Map<? super T, ? extends Parser<? extends To>> map) {
        return new BindNextParser(this, map);
    }

    public final Parser<T> followedBy(Parser<?> parser) {
        return Parsers.sequence(this, parser, InternalFunctors.firstOfTwo());
    }

    public final Parser<T> notFollowedBy(Parser<?> parser) {
        return this.followedBy(parser.not());
    }

    public final Parser<_> repeat_(int n) {
        Checks.checkNonNegative(n, "n < 0");
        return new RepeatParser(this, n);
    }

    public final Parser<List<T>> repeat(int n) {
        Checks.checkNonNegative(n, "n < 0");
        return new RepeatListParser(this, n);
    }

    public final Parser<List<T>> many() {
        return new ManyListParser(this);
    }

    public final Parser<_> many_() {
        return new ManyParser(this);
    }

    public final Parser<List<T>> many(int min) {
        return new ManyMinListParser(this, Checks.checkMin(min));
    }

    public final Parser<_> many_(int min) {
        return new ManyMinParser(this, min);
    }

    public final Parser<List<T>> some(int min, int max) {
        Checks.checkMinMax(min, max);
        return new SomeMinMaxListParser(this, min, max);
    }

    public final Parser<_> some_(int min, int max) {
        Checks.checkMinMax(min, max);
        return new SomeMinMaxParser(this, min, max);
    }

    public final Parser<_> some_(int max) {
        return new SomeMaxParser(Checks.checkMax(max), this);
    }

    public final Parser<List<T>> some(int max) {
        return new SomeMaxListParser(this, Checks.checkMax(max));
    }

    public final Parser<List<T>> many1() {
        return this.many(1);
    }

    public final Parser<_> many1_() {
        return this.many_(1);
    }

    public final <R> Parser<R> map(Map<? super T, ? extends R> map) {
        return new MapParser<T, R>(this, map);
    }

    public final <B, R> Parser<R> and(Parser<B> parser, Map2<? super T, ? super B, ? extends R> map) {
        return Parsers.sequence(this, parser, map);
    }

    public final Parser<T> or(Parser<? extends T> alternative) {
        return Parsers.or(this, alternative);
    }

    public final Parser<T> optional() {
        return Parsers.plus(this, Parsers.always());
    }

    public final Parser<T> optional(T defaultValue) {
        return Parsers.plus(this, Parsers.constant(defaultValue));
    }

    public final Parser<?> not() {
        return this.not(this.toString());
    }

    public final Parser<?> not(String unexpected) {
        return this.peek().ifelse(Parsers.unexpected(unexpected), Parsers.always());
    }

    public final Parser<T> peek() {
        return new PeekParser(this);
    }

    public final Parser<T> atomic() {
        return new AtomicParser(this);
    }

    final Parser<T> step(int n) {
        Checks.checkArgument(n >= 0, "step < 0", new Object[0]);
        return new StepParser(this, n);
    }

    public final Parser<Boolean> succeeds() {
        return this.ifelse(Parsers.TRUE, Parsers.FALSE);
    }

    public final Parser<Boolean> fails() {
        return this.ifelse(Parsers.FALSE, Parsers.TRUE);
    }

    public final <R> Parser<R> ifelse(Parser<? extends R> consequence, Parser<? extends R> alternative) {
        return this.ifelse(Maps.constant(consequence), alternative);
    }

    public final <R> Parser<R> ifelse(Map<? super T, ? extends Parser<? extends R>> consequence, Parser<? extends R> alternative) {
        return new IfElseParser<R, T>(this, consequence, alternative);
    }

    public final Parser<T> label(String name) {
        return Parsers.plus(this, Parsers.expect(name));
    }

    public final <R> Parser<R> cast() {
        return this;
    }

    public final Parser<T> between(Parser<?> before, Parser<?> after) {
        return before.next(this.followedBy(after));
    }

    public final Parser<_> sepBy1_(Parser<?> delimiter) {
        return this.next(delimiter.step(0).next(this).many_());
    }

    public final Parser<List<T>> sepBy1(Parser<?> delimiter) {
        final Parser afterFirst = delimiter.step(0).next(this);
        Map binder = new Map<T, Parser<List<T>>>(){

            @Override
            public Parser<List<T>> map(T firstValue) {
                return new ManyListParser(afterFirst, ListFactories.arrayListFactoryWithFirstElement(firstValue));
            }
        };
        return this.next(binder);
    }

    public final Parser<_> sepBy_(Parser<?> delimiter) {
        return Parsers.plus(this.sepBy1_(delimiter), Parsers.always());
    }

    public final Parser<List<T>> sepBy(Parser<?> delimiter) {
        return Parsers.plus(this.sepBy1(delimiter), EmptyListParser.instance());
    }

    public final Parser<_> endBy_(Parser<?> delimiter) {
        return this.followedBy(delimiter).many_();
    }

    public final Parser<List<T>> endBy(Parser<?> delimiter) {
        return this.followedBy(delimiter).many();
    }

    public final Parser<_> endBy1_(Parser<?> delimiter) {
        return this.followedBy(delimiter).many1_();
    }

    public final Parser<List<T>> endBy1(Parser<?> delimiter) {
        return this.followedBy(delimiter).many1();
    }

    public final Parser<_> sepEndBy1_(Parser<?> delimiter) {
        return this.next(new DelimitedParser(this, delimiter));
    }

    public final Parser<List<T>> sepEndBy1(final Parser<?> delimiter) {
        return this.next(new Map<T, Parser<List<T>>>(){

            @Override
            public Parser<List<T>> map(T first) {
                return new DelimitedListParser(Parser.this, delimiter, ListFactories.arrayListFactoryWithFirstElement(first));
            }
        });
    }

    public final Parser<_> sepEndBy_(Parser<?> delimiter) {
        return Parsers.plus(this.sepEndBy1_(delimiter), Parsers.always());
    }

    public final Parser<List<T>> sepEndBy(Parser<?> delimiter) {
        return Parsers.plus(this.sepEndBy1(delimiter), EmptyListParser.instance());
    }

    public final Parser<T> prefix(Parser<? extends Map<? super T, ? extends T>> op) {
        return op.many().and(this, Parsers.PREFIX_OPERATOR_MAP2);
    }

    public final Parser<T> postfix(Parser<? extends Map<? super T, ? extends T>> op) {
        return this.and(op.many(), Parsers.POSTFIX_OPERATOR_MAP2);
    }

    public final Parser<T> infixn(Parser<? extends Map2<? super T, ? super T, ? extends T>> op) {
        return Parsers.infixn(this, op);
    }

    public final Parser<T> infixl(Parser<? extends Map2<? super T, ? super T, ? extends T>> op) {
        return Parsers.infixl(this, op);
    }

    public final Parser<T> infixr(Parser<? extends Map2<? super T, ? super T, ? extends T>> op) {
        return Parsers.infixr(this, op);
    }

    public final Parser<Token> token() {
        return new ToTokenParser(this);
    }

    public final Parser<String> source() {
        return new ReturnSourceParser(this);
    }

    public final Parser<T> from(Parser<? extends Collection<Token>> lexer) {
        return Parsers.nested(Parsers.tokens(lexer), this.followedBy(Parsers.EOF));
    }

    public final Parser<T> from(Parser<?> tokenizer, Parser<_> delim) {
        return this.from(tokenizer.lexer(delim));
    }

    public Parser<List<Token>> lexer(Parser<?> delim) {
        return delim.optional().next(this.token().sepEndBy(delim));
    }

    final T parse(CharSequence source, String moduleName, SourceLocator sourceLocator) {
        return Parsers.parse(source, this.followedBy(Parsers.EOF), sourceLocator, moduleName);
    }

    public final T parse(CharSequence source, String moduleName) {
        return this.parse(source, moduleName, new DefaultSourceLocator(source));
    }

    public final T parse(CharSequence source) {
        return this.parse(source, null);
    }

    public final T parse(Readable readable) throws IOException {
        return this.parse(readable, null);
    }

    public final T parse(Readable readable, String moduleName) throws IOException {
        StringBuilder builder = new StringBuilder();
        Parser.copy(readable, builder);
        return this.parse(builder, moduleName);
    }

    @Private
    static void copy(Readable from, Appendable to) throws IOException {
        int r;
        CharBuffer buf = CharBuffer.allocate(2048);
        while ((r = from.read(buf)) != -1) {
            buf.flip();
            to.append(buf, 0, r);
        }
    }

    final T getReturn(ParseContext ctxt) {
        return (T)ctxt.result;
    }

    private ParserException asParserException(Throwable e, ParseContext ctxt) {
        if (e instanceof ParserException) {
            return (ParserException)e;
        }
        return new ParserException(e, null, ctxt.module, ctxt.locator.locate(ctxt.getIndex()));
    }

    final boolean run(ParseContext ctxt) {
        try {
            return this.apply(ctxt);
        }
        catch (RuntimeException e) {
            throw this.asParserException(e, ctxt);
        }
    }

    abstract boolean apply(ParseContext var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Reference<T>
    extends AtomicReference<Parser<T>> {
        private static final long serialVersionUID = -8778697271614979497L;

        public Parser<T> lazy() {
            return new LazyParser(this);
        }
    }
}

