/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.Collection;
import org.codehaus.jparsec.IntOrder;
import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParserInternals {
    ParserInternals() {
    }

    static void runForBestFit(IntOrder order, Parser<?>[] parsers, int from, ParseContext state, Object originalResult, int originalStep, int originalAt) {
        int bestAt = state.at;
        int bestStep = state.step;
        Object bestResult = state.result;
        for (int i = from; i < parsers.length; ++i) {
            int at2;
            state.set(originalStep, originalAt, originalResult);
            Parser<?> parser = parsers[i];
            boolean ok = parser.run(state);
            if (!ok || !order.compare(at2 = state.at, bestAt)) continue;
            bestAt = at2;
            bestStep = state.step;
            bestResult = state.result;
        }
        state.set(bestStep, bestAt, bestResult);
    }

    static boolean repeat(Parser<?> parser, int n, ParseContext ctxt) {
        for (int i = 0; i < n; ++i) {
            if (parser.run(ctxt)) continue;
            return false;
        }
        return true;
    }

    static boolean many(Parser<?> parser, ParseContext ctxt) {
        int at = ctxt.at;
        int step = ctxt.step;
        while (ParserInternals.greedyRun(parser, ctxt)) {
            int at2 = ctxt.at;
            if (at == at2) {
                return true;
            }
            at = at2;
            step = ctxt.step;
        }
        return ParserInternals.stillThere(ctxt, at, step);
    }

    static boolean some(Parser<?> parser, int max, ParseContext ctxt) {
        for (int i = 0; i < max; ++i) {
            int at = ctxt.at;
            int step = ctxt.step;
            if (ParserInternals.greedyRun(parser, ctxt)) continue;
            return ParserInternals.stillThere(ctxt, at, step);
        }
        return true;
    }

    static <T> boolean repeat(Parser<? extends T> parser, int n, Collection<T> collection, ParseContext ctxt) {
        for (int i = 0; i < n; ++i) {
            if (!parser.run(ctxt)) {
                return false;
            }
            collection.add(parser.getReturn(ctxt));
        }
        return true;
    }

    static <T> boolean some(Parser<? extends T> parser, int max, Collection<T> collection, ParseContext ctxt) {
        for (int i = 0; i < max; ++i) {
            int at = ctxt.at;
            int step = ctxt.step;
            if (!ParserInternals.greedyRun(parser, ctxt)) {
                return ParserInternals.stillThere(ctxt, at, step);
            }
            collection.add(parser.getReturn(ctxt));
        }
        return true;
    }

    static <T> boolean many(Parser<? extends T> parser, Collection<T> collection, ParseContext ctxt) {
        int at = ctxt.at;
        int step = ctxt.step;
        while (ParserInternals.greedyRun(parser, ctxt)) {
            int at2 = ctxt.at;
            if (at == at2) {
                return true;
            }
            at = at2;
            collection.add(parser.getReturn(ctxt));
            step = ctxt.step;
        }
        return ParserInternals.stillThere(ctxt, at, step);
    }

    static boolean stillThere(ParseContext ctxt, int wasAt, int originalStep) {
        if (ctxt.step == originalStep) {
            ctxt.setAt(originalStep, wasAt);
            return true;
        }
        return false;
    }

    static boolean runNestedParser(ParseContext ctxt, ParseContext freshInitState, Parser<?> parser) {
        if (parser.run(freshInitState)) {
            ctxt.set(freshInitState.step, ctxt.at, freshInitState.result);
            return true;
        }
        ctxt.set(ctxt.step, freshInitState.getIndex(), null);
        ParserInternals.copyError(ctxt, freshInitState);
        return false;
    }

    private static void copyError(ParseContext ctxt, ParseContext nestedState) {
        int errorIndex = nestedState.errorIndex();
        ctxt.setErrorState(errorIndex, errorIndex, nestedState.errorType(), nestedState.errors());
        if (!nestedState.isEof()) {
            ctxt.setEncountered(nestedState.getEncountered());
        }
    }

    static boolean greedyRun(Parser<?> parser, ParseContext ctxt) {
        return parser.run(ctxt);
    }

    static boolean runWithoutRecordingError(Parser<?> parser, ParseContext ctxt) {
        boolean oldValue = ctxt.suppressError(true);
        boolean ok = parser.run(ctxt);
        ctxt.suppressError(oldValue);
        return ok;
    }
}

