/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.jparsec.ActionParser;
import org.codehaus.jparsec.ArrayParser;
import org.codehaus.jparsec.BestParser;
import org.codehaus.jparsec.EofParser;
import org.codehaus.jparsec.ExpectParser;
import org.codehaus.jparsec.FailureParser;
import org.codehaus.jparsec.GetIndexParser;
import org.codehaus.jparsec.IntOrders;
import org.codehaus.jparsec.InternalFunctors;
import org.codehaus.jparsec.IsTokenParser;
import org.codehaus.jparsec.ListParser;
import org.codehaus.jparsec.NestedParser;
import org.codehaus.jparsec.NeverParser;
import org.codehaus.jparsec.OrParser;
import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.ScannerState;
import org.codehaus.jparsec.Sequence2Parser;
import org.codehaus.jparsec.Sequence3Parser;
import org.codehaus.jparsec.Sequence4Parser;
import org.codehaus.jparsec.Sequence5Parser;
import org.codehaus.jparsec.SequenceParser;
import org.codehaus.jparsec.SourceLocator;
import org.codehaus.jparsec.SumParser;
import org.codehaus.jparsec.Token;
import org.codehaus.jparsec.TokenMap;
import org.codehaus.jparsec.UnexpectedParser;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.error.ParserException;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Map2;
import org.codehaus.jparsec.functors.Map3;
import org.codehaus.jparsec.functors.Map4;
import org.codehaus.jparsec.functors.Map5;
import org.codehaus.jparsec.functors.Maps;
import org.codehaus.jparsec.functors.Pair;
import org.codehaus.jparsec.functors.Tuple3;
import org.codehaus.jparsec.functors.Tuple4;
import org.codehaus.jparsec.functors.Tuple5;
import org.codehaus.jparsec.util.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parsers {
    public static final Parser<?> EOF = Parsers.eof("EOF");
    public static final Parser<Object> ANY_TOKEN = Parsers.token(new TokenMap<Object>(){

        @Override
        public Object map(Token tok) {
            return tok.value();
        }

        public String toString() {
            return "any token";
        }
    });
    public static final Parser<Integer> INDEX = new GetIndexParser();
    private static final Parser ALWAYS = Parsers.constant(null);
    private static final Parser NEVER = new NeverParser();
    static final Parser<Boolean> TRUE = Parsers.constant(true);
    static final Parser<Boolean> FALSE = Parsers.constant(false);
    static final Map2 PREFIX_OPERATOR_MAP2 = Parsers.prefixOperatorMap2("prefix");
    static final Map2 POSTFIX_OPERATOR_MAP2 = Parsers.postfixOperatorMap2("postfix");
    private static final Map2 INFIXR_OPERATOR_MAP2 = Parsers.toInfixRhs();
    private static final Map2 APPLY_INFIXR_OPERATORS = Parsers.applyInfixrOperators();
    static final Map2 MAP_OPERATOR_AND_RHS_TO_CLOSURE = Parsers.fromOperatorAndRhsToClosure();

    public static <T> Parser<T> always() {
        return ALWAYS;
    }

    public static <T> Parser<T> never() {
        return NEVER;
    }

    static Parser<?> eof(String message) {
        return new EofParser(message);
    }

    public static <T> Parser<T> fail(String message) {
        return new FailureParser(message);
    }

    static <T> T parse(CharSequence src, Parser<T> parser, SourceLocator locator, String module) {
        ScannerState ctxt = new ScannerState(module, src, 0, locator);
        if (!parser.run(ctxt)) {
            throw new ParserException(ctxt.renderError(), ctxt.module, locator.locate(ctxt.errorIndex()));
        }
        return parser.getReturn(ctxt);
    }

    public static Parser<?> runnable(Runnable runnable) {
        return new ActionParser(runnable);
    }

    static Parser<Token[]> tokens(final Parser<? extends Collection<Token>> parser) {
        return parser.map(new Map<Collection<Token>, Token[]>(){

            @Override
            public Token[] map(Collection<Token> list) {
                return list.toArray(new Token[list.size()]);
            }

            public String toString() {
                return parser.toString();
            }
        });
    }

    static <T> Parser<T> nested(Parser<Token[]> lexer, Parser<? extends T> parser) {
        return new NestedParser<T>(lexer, parser);
    }

    public static <T> Parser<T> constant(final T v) {
        return new Parser<T>(){

            @Override
            boolean apply(ParseContext ctxt) {
                ctxt.result = v;
                return true;
            }

            public String toString() {
                return String.valueOf(v);
            }
        };
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<T> p2) {
        return Parsers.sequence(p1, p2, InternalFunctors.lastOfTwo());
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<?> p2, Parser<T> p3) {
        return Parsers.sequence(p1, p2, p3, InternalFunctors.lastOfThree());
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<?> p2, Parser<?> p3, Parser<T> p4) {
        return Parsers.sequence(p1, p2, p3, p4, InternalFunctors.lastOfFour());
    }

    public static <T> Parser<T> sequence(Parser<?> p1, Parser<?> p2, Parser<?> p3, Parser<?> p4, Parser<T> p5) {
        return Parsers.sequence(p1, p2, p3, p4, p5, InternalFunctors.lastOfFive());
    }

    public static <A, B> Parser<Pair<A, B>> pair(Parser<? extends A> p1, Parser<? extends B> p2) {
        return Parsers.sequence(p1, p2, Maps.toPair());
    }

    public static <A, B> Parser<Pair<A, B>> tuple(Parser<? extends A> p1, Parser<? extends B> p2) {
        return Parsers.pair(p1, p2);
    }

    public static <A, B, C> Parser<Tuple3<A, B, C>> tuple(Parser<? extends A> p1, Parser<? extends B> p2, Parser<? extends C> p3) {
        return Parsers.sequence(p1, p2, p3, Maps.toTuple3());
    }

    public static <A, B, C, D> Parser<Tuple4<A, B, C, D>> tuple(Parser<? extends A> p1, Parser<? extends B> p2, Parser<? extends C> p3, Parser<? extends D> p4) {
        return Parsers.sequence(p1, p2, p3, p4, Maps.toTuple4());
    }

    public static <A, B, C, D, E> Parser<Tuple5<A, B, C, D, E>> tuple(Parser<? extends A> p1, Parser<? extends B> p2, Parser<? extends C> p3, Parser<? extends D> p4, Parser<? extends E> p5) {
        return Parsers.sequence(p1, p2, p3, p4, p5, Maps.toTuple5());
    }

    public static Parser<Object[]> array(Parser<?> ... parsers) {
        return new ArrayParser(parsers);
    }

    public static <T> Parser<List<T>> list(Iterable<? extends Parser<? extends T>> parsers) {
        return new ListParser<T>(Parsers.toArray(parsers));
    }

    public static <T> Parser<T> between(Parser<?> before, Parser<T> parser, Parser<?> after) {
        return parser.between(before, after);
    }

    public static <A, B, T> Parser<T> sequence(Parser<A> p1, Parser<B> p2, Map2<? super A, ? super B, ? extends T> map) {
        return new Sequence2Parser<A, B, T>(p1, p2, map);
    }

    public static <A, B, C, T> Parser<T> sequence(Parser<A> p1, Parser<B> p2, Parser<C> p3, Map3<? super A, ? super B, ? super C, ? extends T> map) {
        return new Sequence3Parser<A, B, C, T>(p1, p2, p3, map);
    }

    public static <A, B, C, D, T> Parser<T> sequence(Parser<A> p1, Parser<B> p2, Parser<C> p3, Parser<D> p4, Map4<? super A, ? super B, ? super C, ? super D, ? extends T> map) {
        return new Sequence4Parser<A, B, C, D, T>(p1, p2, p3, p4, map);
    }

    public static <A, B, C, D, E, T> Parser<T> sequence(Parser<A> p1, Parser<B> p2, Parser<C> p3, Parser<D> p4, Parser<E> p5, Map5<? super A, ? super B, ? super C, ? super D, ? super E, ? extends T> map) {
        return new Sequence5Parser<A, B, C, D, E, T>(p1, p2, p3, p4, p5, map);
    }

    public static Parser<Object> sequence(Parser<?> ... parsers) {
        return new SequenceParser(parsers);
    }

    public static Parser<Object> sequence(Iterable<? extends Parser<?>> parsers) {
        return Parsers.sequence(Parsers.toArray(parsers));
    }

    static <T> Parser<T> plus(Parser<? extends T> p1, Parser<? extends T> p2) {
        return new SumParser(p1, p2);
    }

    static <T> Parser<T> plus(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3) {
        return new SumParser(p1, p2, p3);
    }

    static <T> Parser<T> plus(Parser<? extends T> ... alternatives) {
        if (alternatives.length == 0) {
            return Parsers.never();
        }
        if (alternatives.length == 1) {
            return alternatives[0].cast();
        }
        return new SumParser<T>(alternatives);
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2) {
        return Parsers.alt(p1, p2).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3) {
        return Parsers.alt(p1, p2, p3).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4) {
        return Parsers.alt(p1, p2, p3, p4).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5) {
        return Parsers.alt(p1, p2, p3, p4, p5).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6, Parser<? extends T> p7) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6, p7).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6, Parser<? extends T> p7, Parser<? extends T> p8) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6, p7, p8).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> p1, Parser<? extends T> p2, Parser<? extends T> p3, Parser<? extends T> p4, Parser<? extends T> p5, Parser<? extends T> p6, Parser<? extends T> p7, Parser<? extends T> p8, Parser<? extends T> p9) {
        return Parsers.alt(p1, p2, p3, p4, p5, p6, p7, p8, p9).cast();
    }

    public static <T> Parser<T> or(Parser<? extends T> ... alternatives) {
        if (alternatives.length == 0) {
            return Parsers.never();
        }
        if (alternatives.length == 1) {
            return alternatives[0].cast();
        }
        return new OrParser<T>(alternatives);
    }

    public static <T> Parser<T> or(Iterable<? extends Parser<? extends T>> alternatives) {
        return Parsers.or(Parsers.toArray(alternatives));
    }

    private static Parser<Object> alt(Parser<?> ... alternatives) {
        return Parsers.or(alternatives);
    }

    public static <T> Parser<T> longer(Parser<? extends T> p1, Parser<? extends T> p2) {
        return Parsers.longest(p1, p2);
    }

    public static <T> Parser<T> longest(Parser<? extends T> ... parsers) {
        if (parsers.length == 0) {
            return Parsers.never();
        }
        if (parsers.length == 1) {
            return parsers[0].cast();
        }
        return new BestParser<T>(parsers, IntOrders.GT);
    }

    public static <T> Parser<T> longest(Iterable<? extends Parser<? extends T>> parsers) {
        return Parsers.longest(Parsers.toArray(parsers));
    }

    public static <T> Parser<T> shorter(Parser<? extends T> p1, Parser<? extends T> p2) {
        return Parsers.shortest(p1, p2);
    }

    public static <T> Parser<T> shortest(Parser<? extends T> ... parsers) {
        if (parsers.length == 0) {
            return Parsers.never();
        }
        if (parsers.length == 1) {
            return parsers[0].cast();
        }
        return new BestParser<T>(parsers, IntOrders.LT);
    }

    public static <T> Parser<T> shortest(Iterable<? extends Parser<? extends T>> parsers) {
        return Parsers.shortest(Parsers.toArray(parsers));
    }

    public static <T> Parser<T> expect(String name) {
        return new ExpectParser(name);
    }

    public static <T> Parser<T> unexpected(String name) {
        return new UnexpectedParser(name);
    }

    public static <T> Parser<T> token(TokenMap<? extends T> fromToken) {
        return new IsTokenParser<T>(fromToken);
    }

    public static <T> Parser<T> tokenType(Class<? extends T> type, String name) {
        return Parsers.token(InternalFunctors.isTokenType(type, name));
    }

    static <T> Parser<T>[] toArray(Iterable<? extends Parser<? extends T>> parsers) {
        if (parsers instanceof Collection) {
            return Parsers.toArray((Collection)parsers);
        }
        return Parsers.toArrayWithIteration(parsers);
    }

    @Private
    static <T> Parser<T>[] toArrayWithIteration(Iterable<? extends Parser<? extends T>> parsers) {
        ArrayList list = Lists.arrayList();
        for (Parser<T> parser : parsers) {
            list.add(parser);
        }
        return Parsers.toArray(list);
    }

    static <T> Parser<T>[] toArray(Collection<? extends Parser<? extends T>> parsers) {
        return parsers.toArray(new Parser[parsers.size()]);
    }

    static <From> boolean runNext(ParseContext state, Map<? super From, ? extends Parser<?>> next) {
        Parser<?> parser = next.map(state.result);
        return parser.run(state);
    }

    static <T> Parser<T> infixn(final Parser<T> p, final Parser<? extends Map2<? super T, ? super T, ? extends T>> op) {
        return p.next(new Map<T, Parser<T>>(){

            @Override
            public Parser<T> map(final T a) {
                Parser shift = op.and(p, new Map2<Map2<? super T, ? super T, ? extends T>, T, T>(){

                    @Override
                    public T map(Map2<? super T, ? super T, ? extends T> m2, T b) {
                        return m2.map(a, b);
                    }

                    public String toString() {
                        return "shift right operand";
                    }
                });
                return Parsers.plus(shift, Parsers.constant(a));
            }

            public String toString() {
                return "infixn";
            }
        });
    }

    static <T> Parser<T> infixl(Parser<T> p, Parser<? extends Map2<? super T, ? super T, ? extends T>> op) {
        Parser opAndRhs = op.and(p, MAP_OPERATOR_AND_RHS_TO_CLOSURE);
        final Parser afterFirstOperand = opAndRhs.many();
        Map next = new Map<T, Parser<T>>(){

            @Override
            public Parser<T> map(final T first) {
                return afterFirstOperand.map(new Map<List<Map<T, T>>, T>(){

                    @Override
                    public T map(List<Map<T, T>> maps) {
                        return Parsers.applyInfixOperators(first, maps);
                    }

                    public String toString() {
                        return "reduce";
                    }
                });
            }

            public String toString() {
                return "infixl";
            }
        };
        return p.next(next);
    }

    static <T> Parser<T> infixr(Parser<T> p, Parser<? extends Map2<? super T, ? super T, ? extends T>> op) {
        Parser rhs = op.and(p, INFIXR_OPERATOR_MAP2);
        return p.and(rhs.many(), APPLY_INFIXR_OPERATORS);
    }

    private static <T> Map2<List<? extends Map<? super T, ? extends T>>, T, T> prefixOperatorMap2(final String name) {
        return new Map2<List<? extends Map<? super T, ? extends T>>, T, T>(){

            @Override
            public T map(List<? extends Map<? super T, ? extends T>> ops, T a) {
                return Parsers.applyPrefixOperators(a, ops);
            }

            public String toString() {
                return name;
            }
        };
    }

    private static <T> T applyInfixOperators(T initialValue, List<Map<T, T>> maps) {
        T result = initialValue;
        for (Map<T, T> map : maps) {
            result = map.map(result);
        }
        return result;
    }

    private static <T> T applyPrefixOperators(T a, List<? extends Map<? super T, ? extends T>> ms) {
        for (int i = ms.size() - 1; i >= 0; --i) {
            Map<T, T> m = ms.get(i);
            a = m.map(a);
        }
        return a;
    }

    private static <T> Map2<T, List<? extends Map<? super T, ? extends T>>, T> postfixOperatorMap2(final String name) {
        return new Map2<T, List<? extends Map<? super T, ? extends T>>, T>(){

            @Override
            public T map(T a, List<? extends Map<? super T, ? extends T>> ops) {
                return Parsers.applyPostfixOperators(a, ops);
            }

            public String toString() {
                return name;
            }
        };
    }

    private static <T> T applyPostfixOperators(T a, Iterable<? extends Map<? super T, ? extends T>> ms) {
        for (Map<T, T> m : ms) {
            a = m.map(a);
        }
        return a;
    }

    private static <T> Map2<Map2<? super T, ? super T, ? extends T>, T, Rhs<T>> toInfixRhs() {
        return new Map2<Map2<? super T, ? super T, ? extends T>, T, Rhs<T>>(){

            @Override
            public Rhs<T> map(Map2<? super T, ? super T, ? extends T> m2, T b) {
                return new Rhs(m2, b);
            }

            public String toString() {
                return "operator and right operand";
            }
        };
    }

    private static final <T> Map2<T, List<Rhs<T>>, T> applyInfixrOperators() {
        return new Map2<T, List<Rhs<T>>, T>(){

            @Override
            public T map(T first, List<Rhs<T>> rhss) {
                if (rhss.isEmpty()) {
                    return first;
                }
                int lastIndex = rhss.size() - 1;
                Object o2 = rhss.get((int)lastIndex).rhs;
                for (int i = lastIndex; i > 0; --i) {
                    Object o1 = rhss.get((int)(i - 1)).rhs;
                    o2 = rhss.get((int)i).op.map(o1, o2);
                }
                return rhss.get((int)0).op.map(first, o2);
            }

            public String toString() {
                return "infixr";
            }
        };
    }

    private static <A, B, R> Map2<Map2<A, B, R>, B, Map<A, R>> fromOperatorAndRhsToClosure() {
        return new Map2<Map2<A, B, R>, B, Map<A, R>>(){

            @Override
            public Map<A, R> map(final Map2<A, B, R> op, final B b) {
                return new Map<A, R>(){

                    @Override
                    public R map(A a) {
                        return op.map(a, b);
                    }

                    public String toString() {
                        return "reduce left operand";
                    }
                };
            }

            public String toString() {
                return "operator and right operand";
            }
        };
    }

    private Parsers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Rhs<T> {
        final Map2<? super T, ? super T, ? extends T> op;
        final T rhs;

        Rhs(Map2<? super T, ? super T, ? extends T> op, T rhs) {
            this.op = op;
            this.rhs = rhs;
        }

        public String toString() {
            return this.op + " " + this.rhs;
        }
    }
}

