/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.AnyCharScanner;
import org.codehaus.jparsec.IsCharScanner;
import org.codehaus.jparsec.NestableBlockCommentScanner;
import org.codehaus.jparsec.NestedScanner;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.PatternScanner;
import org.codehaus.jparsec._;
import org.codehaus.jparsec.pattern.CharPredicate;
import org.codehaus.jparsec.pattern.CharPredicates;
import org.codehaus.jparsec.pattern.Pattern;
import org.codehaus.jparsec.pattern.Patterns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scanners {
    public static final Parser<_> WHITESPACES = Scanners.pattern(Patterns.many1(CharPredicates.IS_WHITESPACE), "whitespaces");
    public static final Parser<_> ANY_CHAR = new AnyCharScanner("any character");
    public static final Parser<_> JAVA_LINE_COMMENT = Scanners.lineComment("//");
    public static final Parser<_> SQL_LINE_COMMENT = Scanners.lineComment("--");
    public static final Parser<_> HASKELL_LINE_COMMENT = Scanners.lineComment("--");
    private static final Parser<_> JAVA_BLOCK_COMMENTED = Scanners.pattern(Scanners.notChar2('*', '/').many(), "commented block");
    public static final Parser<_> JAVA_BLOCK_COMMENT = Parsers.sequence(Scanners.string("/*"), JAVA_BLOCK_COMMENTED, Scanners.string("*/"));
    public static final Parser<_> SQL_BLOCK_COMMENT = Parsers.sequence(Scanners.string("/*"), JAVA_BLOCK_COMMENTED, Scanners.string("*/"));
    public static final Parser<_> HASKELL_BLOCK_COMMENT = Parsers.sequence(Scanners.string("{-"), Scanners.pattern(Scanners.notChar2('-', '}').many(), "commented block"), Scanners.string("-}"));
    public static final Parser<String> SINGLE_QUOTE_STRING = Scanners.quotedBy(Scanners.pattern(Patterns.regex("(('')|[^'])*"), "quoted string"), Scanners.isChar('\'')).source();
    public static final Parser<String> DOUBLE_QUOTE_STRING = Scanners.quotedBy(Scanners.pattern(Patterns.regex("((\\\\.)|[^\"\\\\])*"), "quoted string"), Scanners.isChar('\"')).source();
    public static final Parser<String> SINGLE_QUOTE_CHAR = Scanners.quotedBy(Scanners.pattern(Patterns.regex("(\\\\.)|[^'\\\\]"), "quoted char"), Scanners.isChar('\'')).source();
    public static final Parser<_> JAVA_DELIMITER = Parsers.plus(WHITESPACES, JAVA_LINE_COMMENT, JAVA_BLOCK_COMMENT).many_();
    public static final Parser<_> HASKELL_DELIMITER = Parsers.plus(WHITESPACES, HASKELL_LINE_COMMENT, HASKELL_BLOCK_COMMENT).many_();
    public static final Parser<_> SQL_DELIMITER = Parsers.plus(WHITESPACES, SQL_LINE_COMMENT, SQL_BLOCK_COMMENT).many_();
    public static final Parser<String> IDENTIFIER = Scanners.pattern(Patterns.WORD, "word").source();
    public static final Parser<String> INTEGER = Scanners.pattern(Patterns.INTEGER, "integer").source();
    public static final Parser<String> DECIMAL = Scanners.pattern(Patterns.DECIMAL, "decimal").source();
    public static final Parser<String> DEC_INTEGER = Scanners.pattern(Patterns.DEC_INTEGER, "decimal integer").source();
    public static final Parser<String> OCT_INTEGER = Scanners.pattern(Patterns.OCT_INTEGER, "octal integer").source();
    public static final Parser<String> HEX_INTEGER = Scanners.pattern(Patterns.HEX_INTEGER, "hexadecimal integer").source();
    public static final Parser<String> SCIENTIFIC_NOTATION = Scanners.pattern(Patterns.SCIENTIFIC_NOTATION, "scientific notation").source();

    public static Parser<_> many(CharPredicate predicate) {
        return Scanners.pattern(Patterns.isChar(predicate).many(), predicate + "*");
    }

    public static Parser<_> many1(CharPredicate predicate) {
        return Scanners.pattern(Patterns.many1(predicate), predicate + "+");
    }

    public static Parser<_> many(Pattern pattern, String name) {
        return Scanners.pattern(pattern.many(), name);
    }

    public static Parser<_> many1(Pattern pattern, String name) {
        return Scanners.pattern(pattern.many1(), name);
    }

    public static Parser<_> string(String str) {
        return Scanners.string(str, str);
    }

    public static Parser<_> string(String str, String name) {
        return Scanners.pattern(Patterns.string(str), name);
    }

    public static Parser<_> pattern(Pattern pattern, String name) {
        return new PatternScanner(name, pattern);
    }

    public static Parser<_> stringCaseInsensitive(String str, String name) {
        return Scanners.pattern(Patterns.stringCaseInsensitive(str), name);
    }

    public static Parser<_> stringCaseInsensitive(String str) {
        return Scanners.stringCaseInsensitive(str, str);
    }

    public static Parser<_> isChar(CharPredicate predicate) {
        return Scanners.isChar(predicate, predicate.toString());
    }

    public static Parser<_> isChar(CharPredicate predicate, String name) {
        return new IsCharScanner(name, predicate);
    }

    public static Parser<_> isChar(char ch, String name) {
        return Scanners.isChar(CharPredicates.isChar(ch), name);
    }

    public static Parser<_> isChar(char ch) {
        return Scanners.isChar(ch, Character.toString(ch));
    }

    public static Parser<_> notChar(char ch, String name) {
        return Scanners.isChar(CharPredicates.notChar(ch), name);
    }

    public static Parser<_> notChar(char ch) {
        return Scanners.notChar(ch, "^" + ch);
    }

    public static Parser<_> among(String chars, String name) {
        return Scanners.isChar(CharPredicates.among(chars), name);
    }

    public static Parser<_> among(String chars) {
        if (chars.length() == 0) {
            return Scanners.isChar(CharPredicates.NEVER);
        }
        if (chars.length() == 1) {
            return Scanners.isChar(chars.charAt(0));
        }
        return Scanners.isChar(CharPredicates.among(chars));
    }

    public static Parser<_> notAmong(String chars, String name) {
        return Scanners.isChar(CharPredicates.notAmong(chars), name);
    }

    public static Parser<_> notAmong(String chars) {
        if (chars.length() == 0) {
            return ANY_CHAR;
        }
        if (chars.length() == 1) {
            return Scanners.notChar(chars.charAt(0));
        }
        return Scanners.isChar(CharPredicates.notAmong(chars));
    }

    public static Parser<_> lineComment(String begin) {
        return Scanners.pattern(Patterns.lineComment(begin), begin);
    }

    public static Parser<_> blockComment(String begin, String end) {
        Pattern opening = Patterns.string(begin).next(Patterns.notString(end).many());
        return Scanners.pattern(opening, begin).next(Scanners.string(end));
    }

    public static Parser<_> blockComment(String begin, String end, Pattern commented) {
        Pattern opening = Patterns.string(begin).next(Patterns.string(end).not().next(commented).many());
        return Scanners.pattern(opening, begin).next(Scanners.string(end));
    }

    public static Parser<_> blockComment(Parser<_> begin, Parser<_> end, Parser<?> commented) {
        return Parsers.sequence(begin, end.not().next(commented).many_(), end);
    }

    public static Parser<_> nestableBlockComment(String begin, String end) {
        return Scanners.nestableBlockComment(begin, end, Patterns.isChar(CharPredicates.ALWAYS));
    }

    public static Parser<_> nestableBlockComment(String begin, String end, Pattern commented) {
        return Scanners.nestableBlockComment(Scanners.string(begin), Scanners.string(end), Scanners.pattern(commented, "commented"));
    }

    public static Parser<_> nestableBlockComment(Parser<?> begin, Parser<?> end, Parser<?> commented) {
        return new NestableBlockCommentScanner(begin, end, commented);
    }

    public static Parser<String> quoted(char begin, char end) {
        Pattern beforeClosingQuote = Patterns.isChar(begin).next(Patterns.many(CharPredicates.notChar(end)));
        return Scanners.pattern(beforeClosingQuote, Character.toString(begin)).next(Scanners.isChar(end)).source();
    }

    public static Parser<String> quoted(Parser<_> begin, Parser<_> end, Parser<?> quoted) {
        return Parsers.sequence(begin, quoted.many_(), end).source();
    }

    public static Parser<_> nestedScanner(Parser<?> outer, Parser<_> inner) {
        return new NestedScanner(outer, inner);
    }

    private static Pattern notChar2(final char c1, final char c2) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (begin == end - 1) {
                    return 1;
                }
                if (begin >= end) {
                    return -1;
                }
                if (src.charAt(begin) == c1 && src.charAt(begin + 1) == c2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private static Parser<_> quotedBy(Parser<_> parser, Parser<?> quote) {
        return parser.between(quote, quote);
    }

    private Scanners() {
    }
}

