/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.functors.Map2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Sequence2Parser<A, B, T>
extends Parser<T> {
    private final Parser<A> p1;
    private final Parser<B> p2;
    private final Map2<? super A, ? super B, ? extends T> m2;

    Sequence2Parser(Parser<A> p1, Parser<B> p2, Map2<? super A, ? super B, ? extends T> m2) {
        this.p1 = p1;
        this.p2 = p2;
        this.m2 = m2;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        boolean r1 = this.p1.run(ctxt);
        if (!r1) {
            return false;
        }
        A o1 = this.p1.getReturn(ctxt);
        boolean r2 = this.p2.run(ctxt);
        if (!r2) {
            return false;
        }
        B o2 = this.p2.getReturn(ctxt);
        ctxt.result = this.m2.map(o1, o2);
        return true;
    }

    public String toString() {
        return this.m2.toString();
    }
}

