/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.ParseContext;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.functors.Map4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Sequence4Parser<A, B, C, D, T>
extends Parser<T> {
    private final Parser<A> p1;
    private final Parser<B> p2;
    private final Parser<C> p3;
    private final Parser<D> p4;
    private final Map4<? super A, ? super B, ? super C, ? super D, ? extends T> m4;

    Sequence4Parser(Parser<A> p1, Parser<B> p2, Parser<C> p3, Parser<D> p4, Map4<? super A, ? super B, ? super C, ? super D, ? extends T> m4) {
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
        this.m4 = m4;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        boolean r1 = this.p1.run(ctxt);
        if (!r1) {
            return false;
        }
        A o1 = this.p1.getReturn(ctxt);
        boolean r2 = this.p2.run(ctxt);
        if (!r2) {
            return false;
        }
        B o2 = this.p2.getReturn(ctxt);
        boolean r3 = this.p3.run(ctxt);
        if (!r3) {
            return false;
        }
        C o3 = this.p3.getReturn(ctxt);
        boolean r4 = this.p4.run(ctxt);
        if (!r4) {
            return false;
        }
        D o4 = this.p4.getReturn(ctxt);
        ctxt.result = this.m4.map(o1, o2, o3, o4);
        return true;
    }

    public String toString() {
        return this.m4.toString();
    }
}

