/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

final class StringLiteralsTranslator {
    StringLiteralsTranslator() {
    }

    private static final char escapedChar(char c) {
        switch (c) {
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
        }
        return c;
    }

    static String tokenizeDoubleQuote(String text) {
        int end = text.length() - 1;
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            char c1 = text.charAt(++i);
            buf.append(StringLiteralsTranslator.escapedChar(c1));
        }
        return buf.toString();
    }

    static String tokenizeSingleQuote(String text) {
        int end = text.length() - 1;
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '\'') {
                buf.append(c);
                continue;
            }
            buf.append('\'');
            ++i;
        }
        return buf.toString();
    }
}

