/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.IsFragment;
import org.codehaus.jparsec.Keywords;
import org.codehaus.jparsec.Lexicon;
import org.codehaus.jparsec.Operators;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.TokenMap;
import org.codehaus.jparsec.TokenizerMaps;
import org.codehaus.jparsec.Tokens;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.util.Checks;
import org.codehaus.jparsec.util.Objects;
import org.codehaus.jparsec.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Terminals
extends Lexicon {
    public static final Parser<String> RESERVED = Terminals.fragment(new Object[]{Tokens.Tag.RESERVED});

    private Terminals(Lexicon lexicon) {
        super(lexicon.words, lexicon.tokenizer);
    }

    public static Terminals caseInsensitive(String[] ops, String[] keywords) {
        return Terminals.instance(Scanners.IDENTIFIER, ops, keywords, false, TokenizerMaps.IDENTIFIER_FRAGMENT);
    }

    public static Terminals caseSensitive(String[] ops, String[] keywords) {
        return Terminals.instance(Scanners.IDENTIFIER, ops, keywords, true, TokenizerMaps.IDENTIFIER_FRAGMENT);
    }

    public static Terminals caseInsensitive(Parser<String> wordScanner, String[] ops, String[] keywords) {
        return Terminals.caseInsensitive(wordScanner, ops, keywords, TokenizerMaps.IDENTIFIER_FRAGMENT);
    }

    public static Terminals caseSensitive(Parser<String> wordScanner, String[] ops, String[] keywords) {
        return Terminals.caseSensitive(wordScanner, ops, keywords, TokenizerMaps.IDENTIFIER_FRAGMENT);
    }

    public static Terminals caseInsensitive(Parser<String> wordScanner, String[] ops, String[] keywords, Map<String, ?> wordMap) {
        return Terminals.instance(wordScanner, ops, keywords, false, wordMap);
    }

    public static Terminals caseSensitive(Parser<String> wordScanner, String[] ops, String[] keywords, Map<String, ?> wordMap) {
        return Terminals.instance(wordScanner, ops, keywords, true, wordMap);
    }

    public static Terminals operators(String ... ops) {
        return new Terminals(Operators.lexicon(ops));
    }

    public static Parser<String> fragment(Object ... tags) {
        return Parsers.token(Terminals.fromFragment(tags));
    }

    static TokenMap<String> fromFragment(final Object ... tags) {
        return new IsFragment(){

            boolean isExpectedTag(Object type) {
                return Objects.in(type, tags);
            }

            public String toString() {
                if (tags.length == 0) {
                    return "";
                }
                if (tags.length == 1) {
                    return String.valueOf(tags[0]);
                }
                return "[" + Strings.join(", ", tags) + "]";
            }
        };
    }

    private static Terminals instance(Parser<String> wordScanner, String[] ops, String[] keywords, boolean caseSensitive, Map<String, ?> wordMap) {
        Terminals.checkDup(ops, keywords, true);
        Lexicon operators = Operators.lexicon(ops);
        Lexicon keywordsOrWords = Keywords.lexicon(wordScanner, keywords, caseSensitive, wordMap);
        return new Terminals(operators.union(keywordsOrWords));
    }

    @Private
    static boolean equals(String a, String b, boolean caseSensitive) {
        return caseSensitive ? a.equals(b) : a.equalsIgnoreCase(b);
    }

    @Private
    static void checkDup(String[] a, String[] b, boolean caseSensitive) {
        for (String s1 : a) {
            for (String s2 : b) {
                Checks.checkArgument(!Terminals.equals(s1, s2, caseSensitive), "%s duplicated", s1);
            }
        }
    }

    public static final class Identifier {
        public static final Parser<String> PARSER = Terminals.fragment(new Object[]{Tokens.Tag.IDENTIFIER});
        public static final Parser<Tokens.Fragment> TOKENIZER = Scanners.IDENTIFIER.map(TokenizerMaps.IDENTIFIER_FRAGMENT);

        private Identifier() {
        }
    }

    public static final class ScientificNumberLiteral {
        public static final Parser<Tokens.ScientificNotation> PARSER = Parsers.tokenType(Tokens.ScientificNotation.class, "scientific number literal");
        public static final Parser<Tokens.ScientificNotation> TOKENIZER = Scanners.SCIENTIFIC_NOTATION.map(TokenizerMaps.SCIENTIFIC_NOTATION);

        private ScientificNumberLiteral() {
        }
    }

    public static final class DecimalLiteral {
        public static final Parser<String> PARSER = Terminals.fragment(new Object[]{Tokens.Tag.DECIMAL});
        public static final Parser<Tokens.Fragment> TOKENIZER = Scanners.DECIMAL.map(TokenizerMaps.DECIMAL_FRAGMENT);

        private DecimalLiteral() {
        }
    }

    public static final class IntegerLiteral {
        public static final Parser<String> PARSER = Terminals.fragment(new Object[]{Tokens.Tag.INTEGER});
        public static final Parser<Tokens.Fragment> TOKENIZER = Scanners.INTEGER.map(TokenizerMaps.INTEGER_FRAGMENT);

        private IntegerLiteral() {
        }
    }

    public static final class LongLiteral {
        public static final Parser<Long> PARSER = Parsers.tokenType(Long.class, "integer literal");
        public static final Parser<Long> DEC_TOKENIZER = Scanners.DEC_INTEGER.map(TokenizerMaps.DEC_AS_LONG);
        public static final Parser<Long> OCT_TOKENIZER = Scanners.OCT_INTEGER.map(TokenizerMaps.OCT_AS_LONG);
        public static final Parser<Long> HEX_TOKENIZER = Scanners.HEX_INTEGER.map(TokenizerMaps.HEX_AS_LONG);
        public static final Parser<Long> TOKENIZER = Parsers.plus(HEX_TOKENIZER, DEC_TOKENIZER, OCT_TOKENIZER);

        private LongLiteral() {
        }
    }

    public static final class StringLiteral {
        public static final Parser<String> PARSER = Parsers.tokenType(String.class, "string literal");
        public static final Parser<String> DOUBLE_QUOTE_TOKENIZER = Scanners.DOUBLE_QUOTE_STRING.map(TokenizerMaps.DOUBLE_QUOTE_STRING);
        public static final Parser<String> SINGLE_QUOTE_TOKENIZER = Scanners.SINGLE_QUOTE_STRING.map(TokenizerMaps.SINGLE_QUOTE_STRING);

        private StringLiteral() {
        }
    }

    public static final class CharLiteral {
        public static final Parser<Character> PARSER = Parsers.tokenType(Character.class, "character literal");
        public static final Parser<Character> SINGLE_QUOTE_TOKENIZER = Scanners.SINGLE_QUOTE_CHAR.map(TokenizerMaps.SINGLE_QUOTE_CHAR);

        private CharLiteral() {
        }
    }
}

