/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec;

import org.codehaus.jparsec.NumberLiteralsTranslator;
import org.codehaus.jparsec.StringLiteralsTranslator;
import org.codehaus.jparsec.Tokens;
import org.codehaus.jparsec.functors.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TokenizerMaps {
    static final Map<String, Tokens.Fragment> RESERVED_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.RESERVED);
    static final Map<String, Tokens.Fragment> IDENTIFIER_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.IDENTIFIER);
    static final Map<String, Tokens.Fragment> INTEGER_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.INTEGER);
    static final Map<String, Tokens.Fragment> DECIMAL_FRAGMENT = TokenizerMaps.fragment((Object)Tokens.Tag.DECIMAL);
    static final Map<String, Tokens.ScientificNotation> SCIENTIFIC_NOTATION = new Map<String, Tokens.ScientificNotation>(){

        @Override
        public Tokens.ScientificNotation map(String text) {
            int e = text.indexOf(101);
            if (e < 0) {
                e = text.indexOf(69);
            }
            String significand = text.substring(0, e);
            String exponent = text.substring(e + (text.charAt(e + 1) == '+' ? 2 : 1), text.length());
            return Tokens.scientificNotation(significand, exponent);
        }

        public String toString() {
            return "SCIENTIFIC_NOTATION";
        }
    };
    static final Map<String, String> DOUBLE_QUOTE_STRING = new Map<String, String>(){

        @Override
        public String map(String text) {
            return StringLiteralsTranslator.tokenizeDoubleQuote(text);
        }

        public String toString() {
            return "DOUBLE_QUOTE_STRING";
        }
    };
    static final Map<String, String> SINGLE_QUOTE_STRING = new Map<String, String>(){

        @Override
        public String map(String text) {
            return StringLiteralsTranslator.tokenizeSingleQuote(text);
        }

        public String toString() {
            return "SINGLE_QUOTE_STRING";
        }
    };
    static final Map<String, Character> SINGLE_QUOTE_CHAR = new Map<String, Character>(){

        @Override
        public Character map(String text) {
            int len = text.length();
            if (len == 3) {
                return Character.valueOf(text.charAt(1));
            }
            if (len == 4) {
                return Character.valueOf(text.charAt(2));
            }
            throw new IllegalStateException("illegal char");
        }

        public String toString() {
            return "SINGLE_QUOTE_CHAR";
        }
    };
    static final Map<String, Long> DEC_AS_LONG = new Map<String, Long>(){

        @Override
        public Long map(String text) {
            return NumberLiteralsTranslator.tokenizeDecimalAsLong(text);
        }

        public String toString() {
            return "DEC_AS_LONG";
        }
    };
    static final Map<String, Long> OCT_AS_LONG = new Map<String, Long>(){

        @Override
        public Long map(String text) {
            return NumberLiteralsTranslator.tokenizeOctalAsLong(text);
        }

        public String toString() {
            return "OCT_AS_LONG";
        }
    };
    static final Map<String, Long> HEX_AS_LONG = new Map<String, Long>(){

        @Override
        public Long map(String text) {
            return NumberLiteralsTranslator.tokenizeHexAsLong(text);
        }

        public String toString() {
            return "HEX_AS_LONG";
        }
    };

    TokenizerMaps() {
    }

    static Map<String, Tokens.Fragment> fragment(final Object tag) {
        return new Map<String, Tokens.Fragment>(){

            @Override
            public Tokens.Fragment map(String text) {
                return Tokens.fragment(text, tag);
            }

            public String toString() {
                return String.valueOf(tag);
            }
        };
    }
}

