/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.error;

import org.codehaus.jparsec.error.ErrorReporter;
import org.codehaus.jparsec.error.Location;
import org.codehaus.jparsec.error.ParseErrorDetails;

public class ParserException
extends RuntimeException {
    private static final long serialVersionUID = 2600007839521501281L;
    private final ParseErrorDetails error;
    private final Location location;
    private final String module;

    public ParserException(ParseErrorDetails details, String moduleName, Location location) {
        super(ParserException.toErrorMessage(null, moduleName, details, location));
        this.error = details;
        this.module = moduleName;
        this.location = location;
    }

    public ParserException(Throwable cause, ParseErrorDetails details, String moduleName, Location location) {
        super(ParserException.toErrorMessage(cause.getMessage(), moduleName, details, location), cause);
        this.error = details;
        this.location = location;
        this.module = moduleName;
    }

    public ParseErrorDetails getErrorDetails() {
        return this.error;
    }

    private static String toErrorMessage(String message, String module, ParseErrorDetails details, Location location) {
        StringBuilder buf = new StringBuilder();
        if (message != null && message.length() > 0) {
            buf.append(message).append('\n');
        }
        if (module != null) {
            buf.append('(').append(module).append(") ");
        }
        buf.append(ErrorReporter.toString(details, location));
        return buf.toString();
    }

    public String getModuleName() {
        return this.module;
    }

    public Location getLocation() {
        return this.location;
    }
}

