/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.functors;

import java.util.Locale;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Map2;
import org.codehaus.jparsec.functors.Map3;
import org.codehaus.jparsec.functors.Map4;
import org.codehaus.jparsec.functors.Map5;
import org.codehaus.jparsec.functors.Pair;
import org.codehaus.jparsec.functors.Tuple3;
import org.codehaus.jparsec.functors.Tuple4;
import org.codehaus.jparsec.functors.Tuple5;
import org.codehaus.jparsec.functors.Tuples;
import org.codehaus.jparsec.functors.Unary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Maps {
    public static final Map<String, Integer> TO_INTEGER = new Map<String, Integer>(){

        @Override
        public Integer map(String v) {
            return Integer.valueOf(v);
        }

        public String toString() {
            return "integer";
        }
    };
    public static Unary<String> TO_LOWER_CASE = Maps.toLowerCase(Locale.US);
    public static Unary<String> TO_UPPER_CASE = Maps.toUpperCase(Locale.US);
    private static final Map2 ID2 = new Map2(){

        public Pair map(Object a, Object b) {
            return Tuples.pair(a, b);
        }

        public String toString() {
            return "pair";
        }
    };
    private static final Map3 ID3 = new Map3(){

        public Tuple3 map(Object a, Object b, Object c) {
            return Tuples.tuple(a, b, c);
        }

        public String toString() {
            return "tuple";
        }
    };
    private static final Map4 ID4 = new Map4(){

        public Tuple4 map(Object a, Object b, Object c, Object d) {
            return Tuples.tuple(a, b, c, d);
        }

        public String toString() {
            return "tuple";
        }
    };
    private static final Map5 ID5 = new Map5(){

        public Tuple5 map(Object a, Object b, Object c, Object d, Object e) {
            return Tuples.tuple(a, b, c, d, e);
        }

        public String toString() {
            return "tuple";
        }
    };
    private static final Unary<Object> ID = new Unary<Object>(){

        @Override
        public Object map(Object v) {
            return v;
        }

        public String toString() {
            return "identity";
        }
    };
    private static final Map TO_STRING = new Map<Object, String>(){

        @Override
        public String map(Object obj) {
            return String.valueOf(obj);
        }

        public String toString() {
            return "toString";
        }
    };

    public static Unary<String> toLowerCase(final Locale locale) {
        return new Unary<String>(){

            @Override
            public String map(String s) {
                return s.toLowerCase(locale);
            }

            public String toString() {
                return "toLowerCase";
            }
        };
    }

    public static Unary<String> toUpperCase(final Locale locale) {
        return new Unary<String>(){

            @Override
            public String map(String s) {
                return s.toUpperCase(locale);
            }

            public String toString() {
                return "toUpperCase";
            }
        };
    }

    public static <T> Map<T, String> mapToString() {
        return TO_STRING;
    }

    public static <E extends Enum<E>> Map<String, E> toEnum(final Class<E> enumType) {
        return new Map<String, E>(){

            @Override
            public E map(String name) {
                return Enum.valueOf(enumType, name);
            }

            public String toString() {
                return "-> " + enumType.getName();
            }
        };
    }

    public static <T> Unary<T> identity() {
        return ID;
    }

    public static <F, T> Map<F, T> constant(final T v) {
        return new Map<F, T>(){

            @Override
            public T map(F from) {
                return v;
            }

            public String toString() {
                return String.valueOf(v);
            }
        };
    }

    public static <K, V> Map<K, V> map(final java.util.Map<K, V> m) {
        return new Map<K, V>(){

            @Override
            public V map(K k) {
                return m.get(k);
            }

            public String toString() {
                return m.toString();
            }
        };
    }

    public static <A, B> Map2<A, B, Pair<A, B>> toPair() {
        return ID2;
    }

    public static <A, B, C> Map3<A, B, C, Tuple3<A, B, C>> toTuple3() {
        return ID3;
    }

    public static <A, B, C, D> Map4<A, B, C, D, Tuple4<A, B, C, D>> toTuple4() {
        return ID4;
    }

    public static <A, B, C, D, E> Map5<A, B, C, D, E, Tuple5<A, B, C, D, E>> toTuple5() {
        return ID5;
    }

    private Maps() {
    }
}

