/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.misc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.reflect.FastClass;
import org.codehaus.jparsec.annotations.Private;
import org.codehaus.jparsec.misc.Invokable;
import org.codehaus.jparsec.misc.Invokables;
import org.codehaus.jparsec.misc.Mapper;
import org.codehaus.jparsec.misc.Reflection;
import org.codehaus.jparsec.util.Checks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Curry<T>
extends Mapper<T> {
    private final Object[] curryArgs;
    private final int[] curryIndexes;

    private Curry(Object source, Invokable invokable, Object[] curryArgs, int[] curryIndexes) {
        super(source, invokable);
        this.curryArgs = curryArgs;
        this.curryIndexes = curryIndexes;
    }

    public static <T> Curry<T> of(Class<? extends T> clazz, Object ... curryArgs) {
        Checks.checkArgument(!Modifier.isAbstract(clazz.getModifiers()), "Cannot curry abstract class: %s", clazz.getName());
        Constructor<?>[] constructors = clazz.getConstructors();
        Checks.checkArgument(constructors.length == 1, "Expecting 1 public constructor in %s, %s encountered.", clazz.getName(), constructors.length);
        Checks.checkArgument(!constructors[0].isVarArgs(), "Cannot curry for constructor with varargs: %s", constructors[0]);
        Constructor<?> constructor = constructors[0];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int[] curryIndexes = new int[curryArgs.length];
        int curry = 0;
        for (Object curryArg : curryArgs) {
            int curryIndex = Curry.findCurryIndex(constructor, parameterTypes, curry, curryArg);
            Curry.checkDup(curryIndexes, curry, curryIndex, curryArg, constructor);
            curryIndexes[curry++] = curryIndex;
        }
        return new Curry<T>(clazz.getName(), Invokables.constructor(FastClass.create(clazz).getConstructor(constructor)), curryArgs, curryIndexes);
    }

    @Override
    void checkFutureParameters(Class<?> targetType, int providedParameters) {
        int totalProvidedParameters = providedParameters + this.curryArgs.length;
        int totalExpectedParameters = this.invokable.parameterTypes().length;
        this.checkFutureParameters(totalExpectedParameters, targetType, totalProvidedParameters);
    }

    public int hashCode() {
        return ((Object)this.valueList()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Curry) {
            return ((Object)this.valueList()).equals(((Curry)obj).valueList());
        }
        return false;
    }

    private List<?> valueList() {
        return Arrays.asList(this.invokable, Arrays.asList(this.curryArgs));
    }

    private static void checkDup(int[] curryIndexes, int curry, int curryIndex, Object curryArg, Constructor<?> constructor) {
        for (int i = 0; i < curry; ++i) {
            if (curryIndexes[i] != curryIndex) continue;
            throw new IllegalArgumentException("More than one curry arguments match the " + constructor.getParameterTypes()[curryIndex].getName() + " parameter of " + constructor);
        }
    }

    private static int findCurryIndex(Constructor<?> constructor, Class<?>[] parameterTypes, int index, Object object) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!Reflection.isInstance(parameterTypes[i], object)) continue;
            return i;
        }
        throw new IllegalArgumentException("Curry parameter " + index + " is " + Reflection.getClassName(object) + ", which isn't compatible to any parameter of " + constructor);
    }

    @Override
    Object invoke(Object[] args) throws Throwable {
        if (args.length != this.expectedParams()) {
            throw new IllegalArgumentException(this.expectedParams() + " parameters expected, " + args.length + " provided: " + this.invokable);
        }
        Class<?>[] parameterTypes = this.invokable.parameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        int argIndex = 0;
        for (int i = 0; i < actualArgs.length; ++i) {
            int curryIndex = Curry.find(this.curryIndexes, i);
            if (curryIndex >= 0) {
                actualArgs[i] = this.curryArgs[curryIndex];
                continue;
            }
            Class<?> parameterType = parameterTypes[i];
            Object arg = args[argIndex];
            this.checkArgumentType(i, parameterType, arg);
            actualArgs[i] = arg;
            ++argIndex;
        }
        return this.invokable.invoke(actualArgs);
    }

    @Private
    static int find(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    int expectedParams() {
        return super.expectedParams() - this.curryArgs.length;
    }
}

