/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.misc;

import net.sf.cglib.reflect.FastConstructor;
import net.sf.cglib.reflect.FastMethod;
import org.codehaus.jparsec.misc.Invokable;

final class Invokables {
    Invokables() {
    }

    static Invokable constructor(final FastConstructor constructor) {
        final Class ownerType = constructor.getDeclaringClass();
        final Class[] parameterTypes = constructor.getParameterTypes();
        return new ValueInvokable(ownerType){

            @Override
            public Object invoke(Object[] args) throws Throwable {
                return constructor.newInstance(args);
            }

            @Override
            public Class<?>[] parameterTypes() {
                return parameterTypes;
            }

            @Override
            public Class<?> returnType() {
                return ownerType;
            }
        };
    }

    static Invokable method(final Object self, final FastMethod method) {
        final Class returnType = method.getReturnType();
        final Class[] parameterTypes = method.getParameterTypes();
        return new ValueInvokable(self){

            @Override
            public Object invoke(Object[] args) throws Throwable {
                return method.invoke(self, args);
            }

            @Override
            public Class<?>[] parameterTypes() {
                return parameterTypes;
            }

            @Override
            public Class<?> returnType() {
                return returnType;
            }
        };
    }

    private static abstract class ValueInvokable
    implements Invokable {
        private final Object value;

        ValueInvokable(Object value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValueInvokable) {
                return this.value.equals(((ValueInvokable)obj).value);
            }
            return false;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

