/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.misc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.functors.Binary;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Unary;
import org.codehaus.jparsec.misc.Curry;
import org.codehaus.jparsec.misc.Invokable;
import org.codehaus.jparsec.misc.Invokables;
import org.codehaus.jparsec.misc.Reflection;
import org.codehaus.jparsec.util.Checks;
import org.codehaus.jparsec.util.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mapper<T> {
    private static final ConcurrentHashMap<Class<?>, FastMethod> mapMethods = new ConcurrentHashMap();
    final Object source;
    final Invokable invokable;
    private static final String SKIPPED = new String("skipped");
    private static final Unary<Object> SKIP = new Unary<Object>(){

        @Override
        public Object map(Object v) {
            return v;
        }

        public String toString() {
            return SKIPPED;
        }
    };

    protected Mapper() {
        FastMethod method = Mapper.mapMethod(this.getClass());
        this.source = method;
        this.invokable = Invokables.method(this, method);
    }

    Mapper(Object source, Invokable invokable) {
        this.source = source;
        this.invokable = invokable;
    }

    public static <T> Mapper<T> curry(Class<? extends T> clazz, Object ... curryArgs) {
        return Curry.of(clazz, curryArgs);
    }

    public final Parser<T> sequence(Parser<?> ... parsers) {
        int expectedParameters;
        int providedParameters = (parsers = Mapper.toArray(Mapper.mergeSkipped(parsers))).length;
        Checks.checkArgument(providedParameters == (expectedParameters = this.expectedParams()), "%s parameters expected for sequencing, %s provided.", expectedParameters, providedParameters);
        return Parsers.array(parsers).map(this.asMap());
    }

    public final Parser<Unary<T>> unary() {
        return Parsers.constant(this.asUnary());
    }

    public final Parser<Binary<T>> binary() {
        return Parsers.constant(this.asBinary());
    }

    public final Parser<Unary<T>> prefix(Parser<?> operator) {
        Mapper.checkNotSkipped(operator);
        this.checkFutureParameters(Unary.class, 2);
        return operator.map(new Map<Object, Unary<T>>(){

            @Override
            public Unary<T> map(final Object pre) {
                return new Unary<T>(){

                    @Override
                    public T map(T v) {
                        return Mapper.this.apply(pre, v);
                    }
                };
            }
        });
    }

    public final Parser<Unary<T>> prefix(Parser<?> ... operator) {
        List<Parser<?>> operatorList = Mapper.mergeSkipped(operator);
        if (operatorList.size() == 1) {
            return this.prefix(operatorList.get(0));
        }
        this.checkFutureParameters(Unary.class, operatorList.size() + 1);
        return Parsers.list(operatorList).map(new Map<List<Object>, Unary<T>>(){

            @Override
            public Unary<T> map(final List<Object> list) {
                return new Unary<T>(){

                    @Override
                    public T map(T v) {
                        list.add(v);
                        return Mapper.this.apply(list.toArray());
                    }
                };
            }
        });
    }

    public final Parser<Unary<T>> postfix(Parser<?> operator) {
        Mapper.checkNotSkipped(operator);
        this.checkFutureParameters(Unary.class, 2);
        return operator.map(new Map<Object, Unary<T>>(){

            @Override
            public Unary<T> map(final Object post) {
                return new Unary<T>(){

                    @Override
                    public T map(T v) {
                        return Mapper.this.apply(v, post);
                    }
                };
            }
        });
    }

    public final Parser<Unary<T>> postfix(Parser<?> ... operator) {
        if ((operator = Mapper.toArray(Mapper.mergeSkipped(operator))).length == 1) {
            return this.postfix(operator[0]);
        }
        this.checkFutureParameters(Unary.class, operator.length + 1);
        return Parsers.array(operator).map(new Map<Object[], Unary<T>>(){

            @Override
            public Unary<T> map(final Object[] array) {
                return new Unary<T>(){

                    @Override
                    public T map(T v) {
                        Object[] args = new Object[array.length + 1];
                        args[0] = v;
                        System.arraycopy(array, 0, args, 1, array.length);
                        return Mapper.this.apply(args);
                    }
                };
            }
        });
    }

    public final Parser<Binary<T>> infix(Parser<?> operator) {
        Mapper.checkNotSkipped(operator);
        this.checkFutureParameters(Binary.class, 3);
        return operator.map(new Map<Object, Binary<T>>(){

            @Override
            public Binary<T> map(final Object op) {
                return new Binary<T>(){

                    @Override
                    public T map(T left, T right) {
                        return Mapper.this.apply(left, op, right);
                    }
                };
            }
        });
    }

    public final Parser<Binary<T>> infix(Parser<?> ... operator) {
        if ((operator = Mapper.toArray(Mapper.mergeSkipped(operator))).length == 1) {
            return this.infix(operator[0]);
        }
        this.checkFutureParameters(Binary.class, operator.length + 2);
        return Parsers.array(operator).map(new Map<Object[], Binary<T>>(){

            @Override
            public Binary<T> map(final Object[] array) {
                return new Binary<T>(){

                    @Override
                    public T map(T left, T right) {
                        Object[] args = new Object[array.length + 2];
                        args[0] = left;
                        System.arraycopy(array, 0, args, 1, array.length);
                        args[args.length - 1] = right;
                        return Mapper.this.apply(args);
                    }
                };
            }
        });
    }

    public static final Parser<?> _(Parser<?> parser) {
        return parser.map(SKIP);
    }

    public String toString() {
        return this.source.toString();
    }

    void checkFutureParameters(Class<?> targetType, int providedParameters) {
        this.checkFutureParameters(this.expectedParams(), targetType, providedParameters);
    }

    final void checkFutureParameters(int expectedParameters, Class<?> targetType, int providedParameters) {
        Checks.checkArgument(providedParameters == expectedParameters, "Invalid curry: %s parameters expected by %s, %s will be provided by curried and explicit parameters of %s", expectedParameters, this.invokable, providedParameters, targetType.getName());
    }

    int expectedParams() {
        return this.invokable.parameterTypes().length;
    }

    final String name() {
        return this.invokable.returnType().getName();
    }

    final Unary<T> asUnary() {
        this.checkFutureParameters(Unary.class, 1);
        return new Unary<T>(){

            @Override
            public T map(T v) {
                return Mapper.this.apply(v);
            }

            public String toString() {
                return Mapper.this.name();
            }
        };
    }

    final Binary<T> asBinary() {
        this.checkFutureParameters(Binary.class, 2);
        return new Binary<T>(){

            @Override
            public T map(T left, T right) {
                return Mapper.this.apply(left, right);
            }

            public String toString() {
                return Mapper.this.name();
            }
        };
    }

    final Map<Object[], T> asMap() {
        return new Map<Object[], T>(){

            @Override
            public T map(Object[] args) {
                return Mapper.this.apply(args);
            }

            public String toString() {
                return Mapper.this.name();
            }
        };
    }

    final T apply(Object ... args) {
        try {
            return (T)this.invoke(args);
        }
        catch (Throwable e) {
            throw Mapper.propagate(e);
        }
    }

    static RuntimeException propagate(Throwable e) {
        if (e instanceof InvocationTargetException) {
            return Mapper.propagate(((InvocationTargetException)e).getCause());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new RuntimeException(e);
    }

    Object invoke(Object[] args) throws Throwable {
        this.checkArgumentTypes(args);
        return this.invokable.invoke(args);
    }

    private static FastMethod mapMethod(Class<?> type) {
        FastMethod method = mapMethods.get(type);
        if (method == null) {
            method = Mapper.introspectMapperMethod(type);
            mapMethods.put(type, method);
        }
        return method;
    }

    private static FastMethod introspectMapperMethod(Class<?> type) {
        Method method = Mapper.findMapMethod(type);
        Checks.checkNotNullState(method, "A method named as 'map' should be defined in %s", type.getName());
        Class<?> targetType = Mapper.getTargetType(type);
        if (targetType != null) {
            Checks.checkState(targetType.isAssignableFrom(Reflection.wrapperClass(method.getReturnType())), "%s should return a subtype of %s", method, targetType.getName());
        }
        return FastClass.create(type).getMethod(method);
    }

    private static Class<?> getTargetType(Class<?> type) {
        ParameterizedType parameterizedType;
        Type genericSuperclass = type.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (parameterizedType = (ParameterizedType)genericSuperclass).getRawType() == Mapper.class) {
            return Mapper.getRawClass(parameterizedType.getActualTypeArguments()[0]);
        }
        Class<?> superclass = type.getSuperclass();
        return superclass == null ? Object.class : Mapper.getTargetType(superclass);
    }

    private static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Mapper.getRawClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    private static Method findMapMethod(Class<?> type) {
        Method mapMethod = null;
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().equals("map")) continue;
            Checks.checkState(mapMethod == null, "only one map method can be defined: %s", type.getName());
            mapMethod = method;
        }
        if (mapMethod != null) {
            return mapMethod;
        }
        Class<?> superclass = type.getSuperclass();
        return superclass == null ? null : Mapper.findMapMethod(superclass);
    }

    private void checkArgumentTypes(Object ... vals) {
        Class<?>[] parameterTypes = this.invokable.parameterTypes();
        if (vals.length != parameterTypes.length) {
            throw new IllegalArgumentException(vals.length + " arguments received, " + parameterTypes.length + " expected: " + this.invokable);
        }
        for (int i = 0; i < vals.length; ++i) {
            this.checkArgumentType(i, parameterTypes[i], vals[i]);
        }
    }

    final void checkArgumentType(int i, Class<?> parameterType, Object arg) {
        if (!Reflection.isAssignable(parameterType, arg)) {
            throw new IllegalArgumentException(parameterType.getName() + " expected for parameter " + i + " of " + this.invokable + ", " + Reflection.getClassName(arg) + " provided.");
        }
    }

    private static boolean isSkipped(Parser<?> parser) {
        return parser.toString() == SKIPPED;
    }

    static Parser<?>[] toArray(Collection<? extends Parser<?>> parsers) {
        return parsers.toArray(new Parser[parsers.size()]);
    }

    private static void checkNotSkipped(Parser<?> operator) {
        Checks.checkArgument(!Mapper.isSkipped(operator), "Cannot skip the only parser parameter.", new Object[0]);
    }

    private static List<Parser<?>> mergeSkipped(Parser<?> ... parsers) {
        ArrayList<Parser<?>> result = Lists.arrayList(parsers.length);
        List<Parser<?>> all = Arrays.asList(parsers);
        for (int i = 0; i < parsers.length; ++i) {
            Parser<?> parser = parsers[i];
            if (Mapper.isSkipped(parser)) {
                int from = i++;
                while (i < parsers.length && Mapper.isSkipped(parsers[i])) {
                    ++i;
                }
                if (i == parsers.length) {
                    Checks.checkArgument(!result.isEmpty(), "Cannot skip all parser parameters.", new Object[0]);
                    Parser<Object> skippedSequence = Parsers.sequence(all.subList(from, i));
                    int lastIndex = result.size() - 1;
                    result.set(lastIndex, result.get(lastIndex).followedBy(skippedSequence));
                    return result;
                }
                result.add(Parsers.sequence(all.subList(from, i + 1)));
                continue;
            }
            result.add(parser);
        }
        return result;
    }
}

