/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.pattern;

import java.util.regex.Matcher;
import org.codehaus.jparsec.pattern.CharPredicate;
import org.codehaus.jparsec.pattern.CharPredicates;
import org.codehaus.jparsec.pattern.Pattern;
import org.codehaus.jparsec.util.Checks;

public final class Patterns {
    public static final Pattern NEVER = new Pattern(){

        public int match(CharSequence src, int begin, int end) {
            return -1;
        }
    };
    public static final Pattern ALWAYS = new Pattern(){

        public int match(CharSequence src, int begin, int end) {
            return 0;
        }
    };
    public static final Pattern ANY_CHAR = Patterns.hasAtLeast(1);
    public static final Pattern EOF = Patterns.hasExact(0);
    public static final Pattern ESCAPED = new Pattern(){

        public int match(CharSequence src, int begin, int end) {
            if (begin >= end - 1) {
                return -1;
            }
            if (src.charAt(begin) == '\\') {
                return 2;
            }
            return -1;
        }
    };
    public static final Pattern INTEGER = Patterns.many1(CharPredicates.IS_DIGIT);
    public static final Pattern STRICT_DECIMAL = INTEGER.next(Patterns.isChar('.').next(Patterns.many(CharPredicates.IS_DIGIT)).optional());
    public static final Pattern FRACTION = Patterns.isChar('.').next(INTEGER);
    public static final Pattern DECIMAL = STRICT_DECIMAL.or(FRACTION);
    public static final Pattern WORD = Patterns.isChar(CharPredicates.IS_ALPHA_).next(Patterns.isChar(CharPredicates.IS_ALPHA_NUMERIC_).many());
    public static final Pattern OCT_INTEGER = Patterns.isChar('0').next(Patterns.many(CharPredicates.range('0', '7')));
    public static final Pattern DEC_INTEGER = Patterns.sequence(Patterns.range('1', '9'), Patterns.many(CharPredicates.IS_DIGIT));
    public static final Pattern HEX_INTEGER = Patterns.string("0x").or(Patterns.string("0X")).next(Patterns.many1(CharPredicates.IS_HEX_DIGIT));
    public static final Pattern SCIENTIFIC_NOTATION = Patterns.sequence(DECIMAL, Patterns.among("eE"), Patterns.among("+-").optional(), INTEGER);
    public static final Pattern REGEXP_PATTERN = Patterns.getRegularExpressionPattern();
    public static final Pattern REGEXP_MODIFIERS = Patterns.getModifiersPattern();

    private Patterns() {
    }

    public static Pattern hasAtLeast(final int n) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (begin + n > end) {
                    return -1;
                }
                return n;
            }
        };
    }

    public static Pattern hasExact(final int n) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (begin + n != end) {
                    return -1;
                }
                return n;
            }
        };
    }

    public static Pattern isChar(char c) {
        return Patterns.isChar(CharPredicates.isChar(c));
    }

    public static Pattern range(char c1, char c2) {
        return Patterns.isChar(CharPredicates.range(c1, c2));
    }

    public static Pattern among(String chars) {
        return Patterns.isChar(CharPredicates.among(chars));
    }

    public static Pattern isChar(final CharPredicate predicate) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (begin >= end) {
                    return -1;
                }
                if (predicate.isChar(src.charAt(begin))) {
                    return 1;
                }
                return -1;
            }
        };
    }

    public static Pattern lineComment(String begin) {
        return Patterns.string(begin).next(Patterns.many(CharPredicates.notChar('\n')));
    }

    public static Pattern string(final String string) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchString(string, src, begin, end);
            }
        };
    }

    public static Pattern stringCaseInsensitive(final String string) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchStringCaseInsensitive(string, src, begin, end);
            }
        };
    }

    public static Pattern notString(final String string) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (begin >= end) {
                    return -1;
                }
                if (Patterns.matchString(string, src, begin, end) == -1) {
                    return 1;
                }
                return -1;
            }
        };
    }

    public static Pattern notStringCaseInsensitive(final String string) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (begin >= end) {
                    return -1;
                }
                if (Patterns.matchStringCaseInsensitive(string, src, begin, end) == -1) {
                    return 1;
                }
                return -1;
            }
        };
    }

    private static boolean compareIgnoreCase(char a, char b) {
        return Character.toLowerCase(a) == Character.toLowerCase(b);
    }

    private static int matchString(String str, CharSequence src, int begin, int end) {
        int slen = str.length();
        if (end - begin < slen) {
            return -1;
        }
        for (int i = 0; i < slen; ++i) {
            char enc;
            char exp = str.charAt(i);
            if (exp == (enc = src.charAt(begin + i))) continue;
            return -1;
        }
        return slen;
    }

    private static int matchStringCaseInsensitive(String str, CharSequence src, int begin, int end) {
        int slen = str.length();
        if (end - begin < slen) {
            return -1;
        }
        for (int i = 0; i < slen; ++i) {
            char enc;
            char exp = str.charAt(i);
            if (Patterns.compareIgnoreCase(exp, enc = src.charAt(begin + i))) continue;
            return -1;
        }
        return slen;
    }

    static Pattern not(final Pattern pp) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (pp.match(src, begin, end) != -1) {
                    return -1;
                }
                return 0;
            }
        };
    }

    static Pattern peek(final Pattern pp) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (pp.match(src, begin, end) == -1) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Pattern and(final Pattern ... patterns) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int ret = 0;
                for (Pattern pattern : patterns) {
                    int l = pattern.match(src, begin, end);
                    if (l == -1) {
                        return -1;
                    }
                    if (l <= ret) continue;
                    ret = l;
                }
                return ret;
            }
        };
    }

    public static Pattern or(final Pattern ... patterns) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                for (Pattern pattern : patterns) {
                    int l = pattern.match(src, begin, end);
                    if (l == -1) continue;
                    return l;
                }
                return -1;
            }
        };
    }

    public static Pattern sequence(final Pattern ... patterns) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int current = begin;
                for (Pattern pattern : patterns) {
                    int l = pattern.match(src, current, end);
                    if (l == -1) {
                        return l;
                    }
                    current += l;
                }
                return current - begin;
            }
        };
    }

    public static Pattern repeat(final int n, final CharPredicate predicate) {
        Checks.checkNonNegative(n, "n < 0");
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchRepeat(n, predicate, src, end, begin, 0);
            }
        };
    }

    static Pattern repeat(final int n, final Pattern pattern) {
        Checks.checkNonNegative(n, "n < 0");
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchRepeat(n, pattern, src, end, begin, 0);
            }
        };
    }

    public static Pattern many(final int min, final CharPredicate predicate) {
        Checks.checkMin(min);
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int minlen = Patterns.matchRepeat(min, predicate, src, end, begin, 0);
                if (minlen == -1) {
                    return -1;
                }
                return Patterns.matchMany(predicate, src, end, begin + minlen, minlen);
            }
        };
    }

    public static Pattern many(final CharPredicate predicate) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchMany(predicate, src, end, begin, 0);
            }
        };
    }

    static Pattern many(final int min, final Pattern pattern) {
        Checks.checkMin(min);
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int minlen = Patterns.matchRepeat(min, pattern, src, end, begin, 0);
                if (-1 == minlen) {
                    return -1;
                }
                return Patterns.matchMany(pattern, src, end, begin + minlen, minlen);
            }
        };
    }

    static Pattern many(final Pattern pattern) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchMany(pattern, src, end, begin, 0);
            }
        };
    }

    public static Pattern some(final int min, final int max, final CharPredicate predicate) {
        Checks.checkMinMax(min, max);
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int minlen = Patterns.matchRepeat(min, predicate, src, end, begin, 0);
                if (minlen == -1) {
                    return -1;
                }
                return Patterns.matchSome(max - min, predicate, src, end, begin + minlen, minlen);
            }
        };
    }

    public static Pattern some(final int max, final CharPredicate predicate) {
        Checks.checkMax(max);
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchSome(max, predicate, src, end, begin, 0);
            }
        };
    }

    static Pattern some(final int min, final int max, final Pattern pp) {
        Checks.checkMinMax(min, max);
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int minlen = Patterns.matchRepeat(min, pp, src, end, begin, 0);
                if (-1 == minlen) {
                    return -1;
                }
                return Patterns.matchSome(max - min, pp, src, end, begin + minlen, minlen);
            }
        };
    }

    static Pattern some(final int max, final Pattern pp) {
        Checks.checkMax(max);
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                return Patterns.matchSome(max, pp, src, end, begin, 0);
            }
        };
    }

    public static Pattern longer(Pattern p1, Pattern p2) {
        return Patterns.longest(p1, p2);
    }

    public static Pattern longest(final Pattern ... patterns) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int r = -1;
                for (Pattern pattern : patterns) {
                    int l = pattern.match(src, begin, end);
                    if (l <= r) continue;
                    r = l;
                }
                return r;
            }
        };
    }

    public static Pattern shorter(Pattern p1, Pattern p2) {
        return Patterns.shortest(p1, p2);
    }

    public static Pattern shortest(final Pattern ... patterns) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int r = -1;
                for (int i = 0; i < patterns.length; ++i) {
                    int l = patterns[i].match(src, begin, end);
                    if (l == -1 || r != -1 && l >= r) continue;
                    r = l;
                }
                return r;
            }
        };
    }

    static Pattern ifelse(final Pattern cond, final Pattern consequence, final Pattern alternative) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int conditionResult = cond.match(src, begin, end);
                if (conditionResult == -1) {
                    return alternative.match(src, begin, end);
                }
                int consequenceResult = consequence.match(src, begin + conditionResult, end);
                if (consequenceResult == -1) {
                    return -1;
                }
                return conditionResult + consequenceResult;
            }
        };
    }

    public static Pattern many1(CharPredicate predicate) {
        return Patterns.many(1, predicate);
    }

    public static Pattern regex(final java.util.regex.Pattern p) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                if (begin > end) {
                    return -1;
                }
                Matcher matcher = p.matcher(src.subSequence(begin, end));
                if (matcher.lookingAt()) {
                    return matcher.end();
                }
                return -1;
            }
        };
    }

    public static Pattern regex(String s) {
        return Patterns.regex(java.util.regex.Pattern.compile(s));
    }

    static Pattern optional(final Pattern pp) {
        return new Pattern(){

            public int match(CharSequence src, int begin, int end) {
                int l = pp.match(src, begin, end);
                return l == -1 ? 0 : l;
            }
        };
    }

    private static int matchRepeat(int n, CharPredicate predicate, CharSequence src, int len, int from, int acc) {
        int tail = from + n;
        if (tail > len) {
            return -1;
        }
        for (int i = from; i < tail; ++i) {
            if (predicate.isChar(src.charAt(i))) continue;
            return -1;
        }
        return n + acc;
    }

    private static int matchRepeat(int n, Pattern pattern, CharSequence src, int len, int from, int acc) {
        int end = from;
        for (int i = 0; i < n; ++i) {
            int l = pattern.match(src, end, len);
            if (l == -1) {
                return -1;
            }
            end += l;
        }
        return end - from + acc;
    }

    private static int matchSome(int max, CharPredicate predicate, CharSequence src, int len, int from, int acc) {
        int k = Math.min(max + from, len);
        for (int i = from; i < k; ++i) {
            if (predicate.isChar(src.charAt(i))) continue;
            return i - from + acc;
        }
        return k - from + acc;
    }

    private static int matchSome(int max, Pattern pattern, CharSequence src, int len, int from, int acc) {
        int begin = from;
        for (int i = 0; i < max; ++i) {
            int l = pattern.match(src, begin, len);
            if (-1 == l) {
                return begin - from + acc;
            }
            begin += l;
        }
        return begin - from + acc;
    }

    private static int matchMany(CharPredicate predicate, CharSequence src, int len, int from, int acc) {
        for (int i = from; i < len; ++i) {
            if (predicate.isChar(src.charAt(i))) continue;
            return i - from + acc;
        }
        return len - from + acc;
    }

    private static int matchMany(Pattern pattern, CharSequence src, int len, int from, int acc) {
        int i = from;
        int l;
        while (-1 != (l = pattern.match(src, i, len))) {
            if (l == 0) {
                return i - from + acc;
            }
            i += l;
        }
        return i - from + acc;
    }

    private static final Pattern getRegularExpressionPattern() {
        Pattern quote = Patterns.isChar('/');
        Pattern escape = Patterns.isChar('\\').next(Patterns.hasAtLeast(1));
        Pattern content = Patterns.or(escape, Patterns.isChar(CharPredicates.notAmong("/\r\n\\")));
        return quote.next(content.many()).next(quote);
    }

    private static final Pattern getModifiersPattern() {
        return Patterns.isChar(CharPredicates.IS_ALPHA).many();
    }
}

